#ifndef _TCPIP_MCAST_H
#define _TCPIP_MCAST_H

#include <ENDIAN.H>

#define MCAST_PHYS_ADDRLEN	6

#if defined(__BIG_ENDIAN)
#define MCAST_PHYS_ADDR(addr, mc)	\
do {					\
	(mc)[0] = 0x01;			\
	(mc)[1] = 0x00;			\
	(mc)[2] = 0x5e;			\
	(mc)[3] = ((addr) >> 16) & 0x7f;\
	(mc)[4] = (addr) >> 8;		\
	(mc)[5] = (addr);		\
} while (0);
#elif defined(__LITTLE_ENDIAN)
#define MCAST_PHYS_ADDR(addr, mc)	\
do {					\
	(mc)[0] = 0x01;			\
	(mc)[1] = 0x00;			\
	(mc)[2] = 0x5e;			\
	(mc)[3] = ((addr) >> 8) & 0x7f;	\
	(mc)[4] = (addr) >> 16;		\
	(mc)[5] = (addr) >> 24;		\
} while (0);
#else
unknown endian !
#endif

#endif
