#ifndef __PORT_SIOREG_H
#define __PORT_SIOREG_H

#define BIOS_COM_PORTS	4

#define SIO_REGSPACE	8

#define SIO_RX		0
#define SIO_TX		0
#define SIO_DLL		0
#define SIO_DLH		1
#define SIO_IER		1
#define  IER_RDI		0x01
#define  IER_THRI		0x02
#define  IER_RLSI		0x04
#define  IER_MSI		0x08
#define SIO_IIR		2
#define  IIR_NO_INT		0x01
#define  IIR_ID_MASK		0x06
#define  IIR_MSI		0x00
#define  IIR_THRI		0x02
#define  IIR_RDI		0x04
#define  IIR_RLSI		0x06
#define SIO_FCR		2
#define  FCR_ENABLE_FIFO	0x01
#define  FCR_CLEAR_RCVR		0x02
#define  FCR_CLEAR_XMIT		0x04
#define  FCR_DMA_SELECT		0x08
#define  FCR_TRIGGER_1		0x00
#define  FCR_TRIGGER_4		0x40
#define  FCR_TRIGGER_8		0x80
#define  FCR_TRIGGER_14		0xc0
#define SIO_EFR		2
#define  EFR_ENI		0x10
#define  EFR_SCD		0x20
#define  EFR_RTS		0x40
#define  EFR_CTS		0x80
#define SIO_LCR		3
#define  LCR_WLEN5		0x00
#define  LCR_WLEN6		0x01
#define  LCR_WLEN7		0x02
#define  LCR_WLEN8		0x03
#define  LCR_STOP		0x04
#define  LCR_PARITY		0x08
#define  LCR_EPAR		0x10
#define  LCR_SPAR		0x20
#define  LCR_SBC		0x40
#define  LCR_DLAB		0x80
#define SIO_MCR		4
#define  MCR_DTR		0x01
#define  MCR_RTS		0x02
#define  MCR_OUT1		0x04
#define  MCR_OUT2		0x08
#define  MCR_LOOP		0x10
#define SIO_LSR		5
#define  LSR_DR			0x01
#define  LSR_OE			0x02
#define  LSR_PE			0x04
#define  LSR_FE			0x08
#define  LSR_BI			0x10
#define  LSR_THRE		0x20
#define  LSR_TEMT		0x40
#define SIO_MSR		6
#define  MSR_DCTS		0x01
#define  MSR_DDSR		0x02
#define  MSR_TERI		0x04
#define  MSR_DDCD		0x08
#define  MSR_CTS		0x10
#define  MSR_DSR		0x20
#define  MSR_RI			0x40
#define  MSR_DCD		0x80
#define SIO_SCR		7

#endif
