#ifndef __SOUND_HDA_H
#define __SOUND_HDA_H

#include <SPAD/AC.H>
#include <SPAD/VM.H>
#include <SPAD/LIBC.H>
#include <SPAD/DEV_KRNL.H>
#include <SYS/TYPES.H>
#include <SYS/SOUNDCARD.H>

extern char dev_name[__MAX_STR_LEN];

#define SPL_SND			SPL_HDA

#define DEFAULT_MEMORY		4194304

#define MAX_DESCS		256
#define MAX_MEMORY_SIZE_	((__u64)PG_SIZE * PG_BANK * MAX_DESCS)
#define MAX_MEMORY_SIZE		((__u32)(MAX_MEMORY_SIZE_ < 0x80000000 ? MAX_MEMORY_SIZE_ : (__u64)0x80000000))

#define OSS_FIXED_RATES
#define OSS_PCI_DMA
#define OSS_DMA_CAPABLE_64
extern char OSS_DMA_USE_64;
#define OSS_CACHEMODE		PAT_UC
#define OSS_PRECISE_TIMING
#define MIN_CHANNELS		1
#define MAX_CHANNELS		1
#define MIN_FRAGS		3
#define MAX_FRAGS		MAX_DESCS
#define OSS_CANT_STOP

#define OSS_MIXER
#define OSS_MIXER_CAPS		0
extern unsigned OSS_MIXER_DEVMASK;
extern unsigned OSS_MIXER_STEREODEVS;
extern unsigned OSS_MIXER_RECMASK;
extern unsigned OSS_MIXER_OUTMASK;

extern __const__ int RATELIST[];
extern unsigned long PLAYBACK_RATES[];
extern unsigned long RECORD_RATES[];

extern __const__ HANDLE_OPERATIONS SOUND_OPERATIONS;

#include "OSS.H"

#endif
