#ifndef __SOUND_HDAREG_H
#define __SOUND_HDAREG_H

#define AZ_GCAP		0x0000
#define  AZ_GCAP_OUT_SHIFT	12
#define  AZ_GCAP_OUT_MASK	15
#define  AZ_GCAP_IN_SHIFT	8
#define  AZ_GCAP_IN_MASK	15
#define  AZ_GCAP_BIDIR_SHIFT	3
#define  AZ_GCAP_BIDIR_MASK	31
#define  AZ_GCAP_SERIAL_OUT	(1 << 1)
#define  AZ_GCAP_64		(1 << 0)
#define AZ_VMIN		0x0002
#define AZ_VMAJ		0x0003
#define AZ_OUTPAY	0x0004
#define AZ_INPAY	0x0006
#define AZ_GCTL		0x0008
#define  AZ_GCTL_UNSOLICITED	(1 << 8)
#define  AZ_GCTL_FLUSH		(1 << 1)
#define  AZ_GCTL_RESET		(1 << 0)
#define AZ_WAKEEN	0x000c
#define  AZ_WAKEEN_SDI0		(1 << 2)
#define  AZ_WAKEEN_SDI1		(1 << 1)
#define  AZ_WAKEEN_SDI2		(1 << 0)
#define AZ_STATESTS	0x000e
#define  AZ_STATESTS_SDI0	(1 << 2)
#define  AZ_STATESTS_SDI1	(1 << 1)
#define  AZ_STATESTS_SDI2	(1 << 0)
#define AZ_GSTS		0x0010
#define  AZ_GSTS_FLUSH_STATUS	(1 << 1)
#define AZ_INTCTL	0x0020
#define  AZ_INTCTL_GIE		(1 << 31)
#define  AZ_INTCTL_CIE		(1 << 30)
#define  AZ_INTCTL_OUTPUT3	(1 << 7)
#define  AZ_INTCTL_OUTPUT2	(1 << 6)
#define  AZ_INTCTL_OUTPUT1	(1 << 5)
#define  AZ_INTCTL_OUTPUT0	(1 << 4)
#define  AZ_INTCTL_INPUT3	(1 << 3)
#define  AZ_INTCTL_INPUT2	(1 << 2)
#define  AZ_INTCTL_INPUT1	(1 << 1)
#define  AZ_INTCTL_INPUT0	(1 << 0)
#define AZ_INTSTS	0x0024
#define  AZ_INTSTS_GIS		(1 << 31)
#define  AZ_INTSTS_CIS		(1 << 30)
#define  AZ_INTSTS_OUTPUT3	(1 << 7)
#define  AZ_INTSTS_OUTPUT2	(1 << 6)
#define  AZ_INTSTS_OUTPUT1	(1 << 5)
#define  AZ_INTSTS_OUTPUT0	(1 << 4)
#define  AZ_INTSTS_INPUT3	(1 << 3)
#define  AZ_INTSTS_INPUT2	(1 << 2)
#define  AZ_INTSTS_INPUT1	(1 << 1)
#define  AZ_INTSTS_INPUT0	(1 << 0)
#define AZ_WALCLK	0x0030
#define AZ_SSYNC	0x0034
#define  AZ_SSYNC_OUTPUT3	(1 << 7)
#define  AZ_SSYNC_OUTPUT2	(1 << 6)
#define  AZ_SSYNC_OUTPUT1	(1 << 5)
#define  AZ_SSYNC_OUTPUT0	(1 << 4)
#define  AZ_SSYNC_INPUT3	(1 << 3)
#define  AZ_SSYNC_INPUT2	(1 << 2)
#define  AZ_SSYNC_INPUT1	(1 << 1)
#define  AZ_SSYNC_INPUT0	(1 << 0)
#define AZ_CORBLBASE	0x0040
#define AZ_CORBUBASE	0x0044
#define AZ_CORBWP	0x0048
#define AZ_CORBRP	0x004a
#define  AZ_CORBRP_RESET	(1 << 15)
#define AZ_CORBCTL	0x004c
#define  AZ_CORBCTL_ENABLE	(1 << 1)
#define  AZ_CORBCTL_CMEI	(1 << 0)
#define AZ_CORBST	0x004d
#define  AZ_CORBST_CMEI		(1 << 0)
#define AZ_CORBSIZE	0x004e
#define  AZ_CORBSIZE_CAP_256	(1 << 6)
#define  AZ_CORBSIZE_CAP_16	(1 << 5)
#define  AZ_CORBSIZE_CAP_2	(1 << 4)
#define  AZ_CORBSIZE_MASK	(3 << 0)
#define  AZ_CORBSIZE_256	(2 << 0)
#define  AZ_CORBSIZE_16		(1 << 0)
#define  AZ_CORBSIZE_2		(0 << 0)
#define AZ_RIRBLBASE	0x0050
#define AZ_RIRBUBASE	0x0054
#define AZ_RIRBWP	0x0058
#define  AZ_RIRBWP_RESET	(1 << 15)
#define AZ_RINTCNT	0x005a
#define AZ_RIRBCTL	0x005c
#define  AZ_RIRBCTL_OVER_INT	(1 << 2)
#define  AZ_RIRBCTL_ENABLE	(1 << 1)
#define  AZ_RIRBCTL_ENABLE_INT	(1 << 0)
#define AZ_RIRBSTS	0x005d
#define  AZ_RIRBSTS_OVER_INT	(1 << 2)
#define  AZ_RIRBSTS_INT		(1 << 0)
#define AZ_RIRBSIZE	0x005e
#define  AZ_RIRBSIZE_CAP_256	(1 << 6)
#define  AZ_RIRBSIZE_CAP_16	(1 << 5)
#define  AZ_RIRBSIZE_CAP_2	(1 << 4)
#define  AZ_RIRBSIZE_MASK	(3 << 0)
#define  AZ_RIRBSIZE_256	(2 << 0)
#define  AZ_RIRBSIZE_16		(1 << 0)
#define  AZ_RIRBSIZE_2		(0 << 0)
#define AZ_IC		0x0060
#define AZ_IR		0x0064
#define AZ_IRS		0x0068
#define  AZ_IRS_IRV		(1 << 1)
#define  AZ_IRS_ICB		(1 << 0)
#define AZ_DPLBASE	0x0070
#define AZ_DPUBASE	0x0074
#define AZ_INPUT0	0x0080
#define AZ_INPUT1	0x00a0
#define AZ_INPUT2	0x00c0
#define AZ_INPUT3	0x00e0
#define AZ_OUTPUT0	0x0100
#define AZ_OUTPUT1	0x0120
#define AZ_OUTPUT2	0x0140
#define AZ_OUTPUT3	0x0160
#define AZ_SDCTL	0x0000
#define  AZ_SDCTL_NUMBER_SHIFT	20
#define  AZ_SDCTL_NUMBER_MASK	15
#define  AZ_SDCTL_BIDI		(1 << 19)
#define  AZ_SDCTL_PRIO		(1 << 18)
#define  AZ_SDCTL_STRIPE_SHIFT	16
#define  AZ_SDCTL_STRIPE_MASK	3
#define  AZ_SDCTL_EN_INT_ERR	(1 << 4)
#define  AZ_SDCTL_EN_INT_FIFO	(1 << 3)
#define  AZ_SDCTL_EN_INT_COMPL	(1 << 2)
#define  AZ_SDCTL_RUN		(1 << 1)
#define  AZ_SDCTL_SRST		(1 << 0)
#define AZ_SDSTS	0x0003
#define  AZ_SDSTS_FIFORDY	(1 << 5)
#define  AZ_SDSTS_ERR		(1 << 4)
#define  AZ_SDSTS_FIFO_ERR	(1 << 3)
#define  AZ_SDSTS_COMPL		(1 << 2)
#define AZ_SDLPIB	0x0004
#define AZ_SDCBL	0x0008
#define AZ_SDLVI	0x000c
#define AZ_SDFIFOW	0x000e
#define AZ_SDFIFOS	0x0010
#define AZ_SDFMT	0x0012
#define  AZ_SDFMT_BASE		(1 << 14)
#define  AZ_SDFMT_MULT_1	(0 << 11)
#define  AZ_SDFMT_MULT_2	(1 << 11)
#define  AZ_SDFMT_MULT_3	(2 << 11)
#define  AZ_SDFMT_MULT_4	(3 << 11)
#define  AZ_SDFMT_DIV_1		(0 << 8)
#define  AZ_SDFMT_DIV_2		(1 << 8)
#define  AZ_SDFMT_DIV_3		(2 << 8)
#define  AZ_SDFMT_DIV_4		(3 << 8)
#define  AZ_SDFMT_DIV_5		(4 << 8)
#define  AZ_SDFMT_DIV_6		(5 << 8)
#define  AZ_SDFMT_DIV_7		(6 << 8)
#define  AZ_SDFMT_DIV_8		(7 << 8)
#define  AZ_SDFMT_RATE_SHIFT	8
#define  AZ_SDFMT_BITS_8	(0 << 4)
#define  AZ_SDFMT_BITS_16	(1 << 4)
#define  AZ_SDFMT_BITS_20	(2 << 4)
#define  AZ_SDFMT_BITS_24	(3 << 4)
#define  AZ_SDFMT_BITS_32	(4 << 4)
#define  AZ_SDFMT_CHAN_MASK	3
#define  AZ_SDFMT_CHAN_SHIFT	0
#define AZ_SDBPL	0x0018
#define AZ_SDBPU	0x001c

#define AZ_REGSPACE	0x0180

struct bm_entry {
	__u64 addr;
	__u32 len;
	__u32 flags;
};

#define BM_IOC		0x1

struct rirb_entry {
	__u32 resp;
	__u32 extd;
};

#define RIRB_CODEC_MASK		0x0f
#define RIRB_UNSOLICITED	0x10
#define CORB_CODEC_SHIFT	28
#define CORB_NODE_SHIFT		20
#define CORB_VERB_SHIFT		0

#endif
