#ifndef __SOUND_OSS_H
#define __SOUND_OSS_H

#include <SPAD/DEV_KRNL.H>

extern IO_STUB OSS_READ;
extern IO_STUB OSS_WRITE;
extern IO_STUB OSS_IOCTL;

void *OSS_LOOKUP(HANDLE *h, char *str, int open_flags);
void OSS_LOOKUP_IO(HANDLE *h, char *str, IORQ *rq, int open_flags);
void OSS_OPEN(HANDLE *h, int open_flags);
int OSS_CLOSE(HANDLE *h, IORQ *rq);
PAGE *OSS_GET_PAGE(HANDLE *h, __v_off idx, int wr);
void OSS_SET_ROOT(HANDLE *h, void *f);

#define FORMAT_RATE(h)		((h)->flags & 0x7ffff)
#define FORMAT_CHANNELS(h)	(((h)->flags >> 19) & 1)
#define FORMAT_FRAGS(h)		(((h)->flags >> 20) & 0xfff)
#define FORMAT_FORMAT(h)	((h)->flags2 & 0xf)
#define FORMAT_FRAGSIZE(h)	(((h)->flags2 >> 4) & 0x1f)
#define FORMAT_NONBLOCK(h)	(((h)->flags2 >> 9) & 1)
#define FORMAT_SUBDIVIDE(h)	(((h)->flags2 >> 10) & 0x3f)

#define FORMAT_SETRATE(h, r)	((h)->flags = ((h)->flags & ~0x7ffffL) | (r))
#define FORMAT_SETCHANNELS(h, c) ((h)->flags = ((h)->flags & ~0x80000L) | (c) << 19)
#define FORMAT_SETFRAGS(h, f)	((h)->flags = ((h)->flags & ~0xfff00000L) | (f) << 20)
#define FORMAT_SETFORMAT(h, f)	((h)->flags2 = ((h)->flags2 & ~0xfL) | (f))
#define FORMAT_SETFRAGSIZE(h, f) ((h)->flags2 = ((h)->flags2 & ~0x1f0L) | (f) << 4)
#define FORMAT_SETNONBLOCK(h, b) ((h)->flags2 = ((h)->flags2 & ~0x200L) | (b) << 9)
#define FORMAT_SETSUBDIVIDE(h, s) ((h)->flags2 = ((h)->flags2 & ~0xFC00L) | (s) << 10)

#define FORMAT_MAXRATE		0x7ffff
#define FORMAT_MAXCHANNELS	0x1
#define FORMAT_MAXFRAGS		0xfff
#define FORMAT_MAXFORMAT	0xf
#define FORMAT_MAXFRAGSIZE	0x1f
#define FORMAT_MAXNONBLOCK	0x1
#define FORMAT_MAXSUBDIVIDE	0x3f

extern int OSS_FLAGS;
#define OSS_PLAYBACK		1
#define OSS_RECORD		2
#define OSS_DUPLEX		4
#define OSS_PLAYBACK_STOP	8
#define OSS_BLOCK_PLAYBACK	16
#define OSS_BLOCK_RECORD	32
#define OSS_LOOP_PLAYBACK	64

extern WQ OSS_PLAYBACK_WAIT;
extern WQ OSS_RECORD_WAIT;

extern int oss_playback_frags, oss_playback_fragsize_bits;
extern int oss_playback_fragment, oss_playback_buf_fragments;
extern int oss_playback_rate, oss_playback_channels, oss_playback_format;
extern off_t oss_playback_file_pos;

extern int oss_playback_stat_bytes, oss_playback_stat_frags;
extern unsigned long oss_playback_stat_bytes_drop;
extern int oss_playback_stat_underruns;

extern int oss_record_frags, oss_record_fragsize_bits;
extern int oss_record_fragment, oss_record_buf_fragments;
extern int oss_record_buf_pos;
extern int oss_record_rate, oss_record_channels, oss_record_format;

extern int oss_record_stat_bytes, oss_record_stat_frags;
extern unsigned long oss_record_stat_bytes_drop;
extern int oss_record_stat_overruns;

int OSS_ALLOC_DMAPAGES(unsigned n_pages, unsigned page_size);
void OSS_FREE_DMAPAGES(void);
extern unsigned N_PAGES, PAGESIZE_BITS;

struct page_desc {
	void *virtual;
#if defined(OSS_ISA_DMA)
	unsigned physical;
#else
	__p_addr physical;
#if defined(OSS_DMA_CAPABLE_64)
	__u64 device;
#else
	__u32 device;
#endif
	union {
		vspace_dmaunlock_t *unlock32;
#if defined(OSS_DMA_CAPABLE_64)
		vspace_dma64unlock_t *unlock64;
#endif
	} u;
#endif
};

extern struct page_desc *PAGES;
extern struct page_desc *CAP_PAGES;

#endif

void SND_FIXUP_PARAMS(HANDLE *h, int open_flags);
void SND_STOP(int record);
void SND_START(int record);
void SND_PAUSE(int record);
void SND_RESUME(int record);
void SND_SUBMIT_FRAGMENT(int record, int frag);
unsigned SND_GET_PTR(int record);

long SND_MIXER_READ(unsigned mix);
void SND_MIXER_WRITE(unsigned mix, unsigned long val);
long SND_MIXER_READ_RECSRC(void);
void SND_MIXER_WRITE_RECSRC(unsigned long mask);
long SND_MIXER_READ_OUTSRC(void);
void SND_MIXER_WRITE_OUTSRC(unsigned long mask);

void TRIGGER_PLAY(void);
void OSS_INIT(int duplex);
void OSS_STOP(int record);
int OSS_PLAYBACK_INTR(void);
int OSS_RECORD_INTR(void);

#ifdef OSS_FIXED_RATES
#define OSS_GET_RATE(x)		(RATELIST[x])
#else
#define OSS_GET_RATE(x)		(x)
#endif

#define TIMEOUT(fragsize_bits, format, channels, rate)	((__u64)_FMT_DIV(1 << (fragsize_bits), format, channels) * (JIFFIES_PER_SECOND * 3) / (OSS_GET_RATE(rate) * 2) + 2)
#define FRAGINTR(fragsize_bits, format, channels, rate)	((__u64)_FMT_DIV(1 << (fragsize_bits), format, channels) * JIFFIES_PER_SECOND / OSS_GET_RATE(rate) - 2)

#define OSS_PLAYBACK_TIMEOUT	TIMEOUT(oss_playback_fragsize_bits, oss_playback_format, oss_playback_channels, oss_playback_rate)
#define OSS_RECORD_TIMEOUT	TIMEOUT(oss_record_fragsize_bits, oss_record_format, oss_record_channels, oss_record_rate)

#define OSS_PLAYBACK_INTRTIME	FRAGINTR(oss_playback_fragsize_bits, oss_playback_format, oss_playback_channels, oss_playback_rate)
#define OSS_RECORD_INTRTIME	FRAGINTR(oss_record_fragsize_bits, oss_record_format, oss_record_channels, oss_record_rate)
