#ifndef __SOUND_VIA82REG_H
#define __SOUND_VIA82REG_H

#define VIA82_REGSPACE		0x100

#define VIA_OUT_CHANNEL_BASE	0x00
#define VIA_IN_CHANNEL_BASE	0x10
#define VIA_FM_CHANNEL_BASE	0x20

#define VIA_NEW_DXS0_CHANNEL_BASE 0x00
#define VIA_NEW_DXS1_CHANNEL_BASE 0x10
#define VIA_NEW_DXS2_CHANNEL_BASE 0x20
#define VIA_NEW_DXS3_CHANNEL_BASE 0x30
#define VIA_NEW_3D_CHANNEL_BASE	0x40
#define VIA_NEW_FM_CHANNEL_BASE	0x50
#define VIA_NEW_IN0_CHANNEL_BASE 0x60
#define VIA_NEW_IN1_CHANNEL_BASE 0x70

#define VIA_STATUS		0x00
#define  VIA_STATUS_FLAG		0x01
#define  VIA_STATUS_EOL			0x02
#define  VIA_STATUS_STOPPED		0x04
#define  VIA_STATUS_ACTIVE		0x80
#define VIA_CONTROL		0x01
#define  VIA_CONTROL_INT_ON_FLAG	0x01
#define  VIA_CONTROL_INT_ON_EOL		0x02
#define  VIA_CONTROL_SGD_PAUSE		0x08
#define  VIA_CONTROL_AUTO_RESTART	0x20
#define  VIA_CONTROL_SGD_TERMINATE	0x40
#define  VIA_CONTROL_SGD_TRIGGER	0x80
#define VIA_TYPE		0x02		/* 686 */
#define  VIA_TYPE_INT_FLAG		0x01
#define  VIA_TYPE_INT_EOL		0x02
#define  VIA_TYPE_INT_MASK		0x0c
#define   VIA_TYPE_INT_LLINE			0x00
#define   VIA_TYPE_INT_LSAMPLE			0x04
#define   VIA_TYPE_INT_LESSONE			0x08
#define  VIA_TYPE_STEREO		0x10
#define  VIA_TYPE_16_BIT		0x20
#define  VIA_TYPE_REC_FIFO		0x40
#define  VIA_TYPE_AUTO_RESTART		0x80
#define  VIA_CH4_TYPE_CHANNELS		0x70
#define  VIA_CH4_TYPE_16BIT		0x80
#define VIA_LEFTVOL		0x02
#define VIA_RIGHTVOL		0x03
#define  VIA_MINVOL			0x3f
#define VIA_ADDR		0x04
#define VIA_STOPRATE		0x08		/* 8233 */
#define  VIA_STOPRATE_SAMPLE_RATE	0x000fffff
#define  VIA_STOPRATE_STEREO		0x00100000
#define  VIA_STOPRATE_16_BIT		0x00200000
#define  VIA_STOPRATE_STOP_IDX		0xff000000
#define VIA_BLOCK_COUNT		0x0c
#define  VIA_BLOCK_COUNT_OFFSET		0x00ffffff
#define  VIA_BLOCK_COUNT_INDEX		0xff000000

#define VIA_AC97_CTRL		0x80
#define  VIA_AC97_CTRL_VALUE		0x0000ffff
#define  VIA_AC97_CTRL_ADDRESS		0x007f0000
#define  VIA_AC97_CTRL_READ		0x00800000
#define  VIA_AC97_CTRL_BUSY		0x01000000
#define  VIA_AC97_CTRL_1ST_CODEC_VALID	0x02000000
#define  VIA_AC97_CTRL_2ND_CODEC_VALID	0x08000000
#define  VIA_AC97_CTRL_2ND_CODEC	0x40000000
#define VIA_SGD_STATUS_SHADOW	0x84
#define VIA_GPI_STATUS		0x88
#define VIA_GPI_INT_ENABLE	0x8c

typedef struct {
	__u32 base;
	__u32 len_flags;
} VIA_DMADESC;

#define DESC_LEN_STOP		0x20000000
#define DESC_LEN_FLAG		0x40000000
#define DESC_LEN_EOL		0x80000000

#define VIA_PCI_AC_STATUS	0x40
#define  VIA_PCI_AC_STATUS_C00_READY	0x01
#define  VIA_PCI_AC_STATUS_LOW_POWER	0x02
#define  VIA_PCI_AC_STATUS_C01_READY	0x04
#define  VIA_PCI_AC_STATUS_C10_READY	0x08
#define  VIA_PCI_AC_STATUS_C11_READY	0x10
#define VIA_PCI_AC_CTRL		0x41
#define  VIA_PCI_AC_CTRL_SB_PCM		0x01
#define  VIA_PCI_AC_CTRL_FM_PCM		0x02
#define  VIA_PCI_AC_CTRL_PCM		0x04
#define  VIA_PCI_AC_CTRL_VRA		0x08
#define  VIA_PCI_AC_CTRL_SDO		0x10
#define  VIA_PCI_AC_CTRL_SYNC		0x20
#define  VIA_PCI_AC_CTRL_RESET		0x40
#define  VIA_PCI_AC_CTRL_ENABLE		0x80
#define VIA_PCI_FN_ENABLE	0x42
#define  VIA_PCI_FN_ENABLE_SB		0x01
#define  VIA_PCI_FN_ENABLE_MIDI		0x02
#define  VIA_PCI_FN_ENABLE_FM		0x04
#define  VIA_PCI_FN_ENABLE_GAME		0x08
#define  VIA_PCI_FN_ENABLE_GATE_SB	0x10
#define  VIA_PCI_FN_ENABLE_RX2C_WRITE	0x20
#define  VIA_PCI_FN_ENABLE_MASK_MIDI_IRQ 0x40
#define  VIA_PCI_FN_ENABLE_MIDI_PNP	0x80
#define VIA_PCI_PNP_CTRL	0x43
#define  VIA_PCI_PNP_CTRL_SB_IO		0x03
#define   VIA_PCI_PNP_CTRL_SB_IO_220		0x00
#define   VIA_PCI_PNP_CTRL_SB_IO_240		0x01
#define   VIA_PCI_PNP_CTRL_SB_IO_260		0x02
#define   VIA_PCI_PNP_CTRL_SB_IO_280		0x03
#define  VIA_PCI_PNP_CTRL_MIDI_IO	0x0c
#define   VIA_PCI_PNP_CTRL_MIDI_IO_300		0x00
#define   VIA_PCI_PNP_CTRL_MIDI_IO_310		0x04
#define   VIA_PCI_PNP_CTRL_MIDI_IO_320		0x08
#define   VIA_PCI_PNP_CTRL_MIDI_IO_330		0x0c
#define  VIA_PCI_PNP_CTRL_SB_DMA	0x30
#define   VIA_PCI_PNP_CTRL_SB_DMA_0		0x00
#define   VIA_PCI_PNP_CTRL_SB_DMA_1		0x10
#define   VIA_PCI_PNP_CTRL_SB_DMA_2		0x20
#define   VIA_PCI_PNP_CTRL_SB_DMA_3		0x30
#define  VIA_PCI_PNP_CTRL_SB_IRQ	0xc0
#define   VIA_PCI_PNP_CTRL_SB_IRQ_5		0x00
#define   VIA_PCI_PNP_CTRL_SB_IRQ_7		0x40
#define   VIA_PCI_PNP_CTRL_SB_IRQ_9		0x80
#define   VIA_PCI_PNP_CTRL_SB_IRQ_10		0xc0
#define VIA_PCI_FN_NMI_CTRL	0x48
#define  VIA_PCI_FN_NMI_CTRL_TRAP_INTERRUPT	0x01
#define  VIA_PCI_FN_NMI_CTRL_SGD_SB		0x02
#define  VIA_PCI_FN_NMI_CTRL_IRQ_SMI		0x04

#endif
