#ifndef __SWAPPER_STRUCT_H
#define __SWAPPER_STRUCT_H

#include <ARCH/LINUXPG.H>

/* parts from linux/include/linux/swap.h (C) someone who wrote it */

#define SWAP_LINUX_V1_MAGIC	"SWAP-SPACE"
#define SWAP_LINUX_V2_MAGIC	"SWAPSPACE2"

#define SWAP_VERSION		1
#define SWAP_MIN_SIZE		(10 * LINUX_PAGE_SIZE)

union swap_header {
	struct {
		char reserved[LINUX_PAGE_SIZE - 10];
		char magic[10];
	} magic;
	struct {
		char bootbits[1024];	/* Space for disklabel etc. */
		unsigned version;
		unsigned last_page;
		unsigned nr_badpages;
		unsigned padding[125];
		unsigned badpages[1];
	} info;
};

#endif
