#ifndef _SWAPPER_SWAPMAP_H
#define _SWAPPER_SWAPMAP_H

#include <SPAD/VM.H>
#include <SPAD/LIST.H>
#include <SPAD/QUOTA.H>
#include <KERNEL/VMDEF.H>
#include <SPAD/LINK.H>
#include <MD5.H>
#include <SHA.H>
#include <RIPEMD.H>
#include <SHA256.H>
#include <SPAD/SWAPPER.H>

#define SWAP_TTY

#define PGDIR_SIZE_BITS		6
#define PGDIR_SIZE		(1 << PGDIR_SIZE_BITS)
#define CHILDHASH_SIZE		64

#if PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	0
#elif PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	1
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	2
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	3
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	4
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	5
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	6
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	7
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	8
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	9
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	10
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	11
#elif PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE * PGDIR_SIZE >= VMSPACE / PAGE_CLUSTER_SIZE
#define PGDIR_DEPTH	12
#else
too deep page dir
#endif
#define PGDIR_DIV_BITS	(PGDIR_SIZE_BITS * PGDIR_DEPTH)
#define PGDIR_DIV	(1 << PGDIR_DIV_BITS)
#define TOP_PGDIR_SIZE	((VMSPACE - 1) / PAGE_CLUSTER_SIZE / PGDIR_DIV + 1)

typedef struct __pagedir PAGEDIR;
typedef struct __swapnode SWAPNODE;
typedef struct __ldcache LDCACHE;
typedef struct __ldref LDREF;

typedef struct {
	unsigned long refcount;	/* must match PAGEDIR */
	unsigned long account;	/* must match PAGEDIR */
	unsigned swap_pos;
	PAGE *page;
} PAGENODE;

struct __pagedir {
	unsigned long refcount;	/* must match PAGENODE */
	unsigned long account;	/* must match PAGENODE */
	PAGEDIR *pagedir[PGDIR_SIZE];
};

#define SWAPCOMMON				\
	PAGEDIR *pagedir[TOP_PGDIR_SIZE];	\
	SWAPNODE *parent;			\
	QUOTA pageq;				\
	QUOTA unpageq;				\
	LIST_ENTRY hash;

#ifdef SWAP_TTY
typedef struct __swaptty SWAPTTY;
extern __const__ unsigned SIZEOF_SWAPTTY;
#endif

struct __swapnode {
	SWAPCOMMON;
	__u64 jobname;
	XLIST_HEAD handles;
	XLIST_HEAD ldrefs;
	SWAPNODE *ldrefsptr;
	int depth;
	XLIST_HEAD childhash[CHILDHASH_SIZE];
#ifdef SWAP_TTY
	SWAPTTY *tty;
#endif
};

struct __ldcache {
	SWAPCOMMON;
	unsigned long ldref_count;
	unsigned long from;
	unsigned long to;
	unsigned hash_type;
	char state;
	char vme_used;
	VMENTITY vme;
	LD_FINAL_HASH link_hash;
	__u8 exported_hash[REL_DIGEST_LENGTH];
	union {
		struct {
			union {
				MD5_CTX md5_ctx;
				SHA_CTX sha1_ctx;
				RIPEMD160_CTX ripemd160_ctx;
				SHA256_CTX sha256_ctx;
			} h;
			unsigned long idx;
			unsigned long data_end;
		} chs;
		struct {
			__f_off diff;
			__f_off reloc_ptr;
			__f_off sec_base[5];
			__f_off sec_len[5];
			__s8 section_to_reloc;
			__u8 cur_section;
			__u8 cur_type;
			__u8 rle_step;
			__u16 rle_count;
			__f_off cur_pos;

			REL_CTX rel_ctx;
			unsigned current_iface;
			__f_off symbols;
			unsigned n_symbols;
		} rel;
		struct {
			char error[128];
		} err;
	} u;
};

#define LD_CREATING			0
#define LD_CHECKSUMMING			1
#define LD_CHECKSUMMED			2
#define LD_RELOCATING			3
#define LD_IFACE_SELECTING		4
#define LD_IFACE_RELOCATING		5
#define LD_FINALIZING			6
#define LD_ERROR			125
#define LD_ESTABLISHED_NONSHARED	126
#define LD_ESTABLISHED			127

struct __ldref {
	LIST_ENTRY list;
	unsigned long nrefs;
	LDCACHE *ldcache;
};

static __finline__ SWAPNODE *ACCT_SWAPNODE(unsigned long acct)
{
	return (SWAPNODE *)(acct & ~1UL);
}

static __finline__ LDCACHE *ACCT_LDCACHE(unsigned long acct)
{
	return (LDCACHE *)(acct - 1UL);
}

static __finline__ unsigned long ACCT_FROM_SWAPNODE(SWAPNODE *sn)
{
	return (unsigned long)sn;
}

static __finline__ unsigned long ACCT_FROM_LDCACHE(LDCACHE *sn)
{
	return (unsigned long)sn + 1;
}

#define ACCT_IS_LDCACHE(acct)	((acct) & 1)

#define unpageq_isroot(q)	(!LIST_STRUCT((q), SWAPNODE, unpageq)->parent)
#define unpageq_parent(q)	(&LIST_STRUCT((q), SWAPNODE, unpageq)->parent->unpageq)
#define unpageq_for_all_subnodes(v, p)					\
{									\
	int __i;							\
	SWAPNODE *__s;							\
	for (__i = 0; __i < CHILDHASH_SIZE; __i++) XLIST_FOR_EACH_UNLIKELY(__s, &LIST_STRUCT(p, SWAPNODE, unpageq)->childhash[__i], SWAPNODE, hash) {	\
		v = &__s->unpageq;					\
		if (1)
#define unpageq_for_all_subnodes_tail(v, p)	}}

#define pageq_isroot(q)		(!LIST_STRUCT((q), SWAPNODE, pageq)->parent)
#define pageq_parent(q)		(&LIST_STRUCT((q), SWAPNODE, pageq)->parent->pageq)
#define pageq_for_all_subnodes(v, p)					\
{									\
	int __i;							\
	SWAPNODE *__s;							\
	for (__i = 0; __i < CHILDHASH_SIZE; __i++) XLIST_FOR_EACH_UNLIKELY(__s, &LIST_STRUCT(p, SWAPNODE, pageq)->childhash[__i], SWAPNODE, hash) {	\
		v = &__s->pageq;					\
		if (1)
#define pageq_for_all_subnodes_tail(v, p)	}}

#define PAGE_FNODE_FREED	0x00000001UL

#endif
