#include <SPAD/VM.H>
#include <SPAD/SYSLOG.H>

#include "SWAPPER.H"
#include "SWAPMAP.H"

#ifdef DEBUG_QUOTA

static void dft(unsigned long s, PAGEDIR *d, int depth, void (*f)(unsigned long s, PAGENODE *p))
{
	if (!d) return;
	if (depth > 0) {
		int i;
		for (i = 0; i < PGDIR_SIZE; i++) dft(s, d->pagedir[i], depth - 1, f);
	} else f(s, (PAGENODE *)d);
}

static void dfs(unsigned long s, void (*f)(unsigned long s, PAGENODE *p), void (*reff)(SWAPNODE *s, LDREF *r))
{
	int i;
	SWAPNODE *ss;
	LDREF *ref;
	if (!ACCT_IS_LDCACHE(s)) {
		for (i = 0; i < CHILDHASH_SIZE; i++) XLIST_FOR_EACH_UNLIKELY(ss, &ACCT_SWAPNODE(s)->childhash[i], SWAPNODE, hash) {
			dfs(ACCT_FROM_SWAPNODE(ss), f, reff);
		}
		XLIST_FOR_EACH(ref, &ACCT_SWAPNODE(s)->ldrefs, LDREF, list) {
			if (__unlikely(ACCT_SWAPNODE(s)->ldrefsptr != ACCT_SWAPNODE(s)))
				KERNEL$SUICIDE("dfs: BAD LDREFS");
			reff(ACCT_SWAPNODE(s), ref);
		}
	}
	for (i = 0; i < TOP_PGDIR_SIZE; i++)
		dft(s, ACCT_SWAPNODE(s)->pagedir[i], PGDIR_DEPTH, f);
}

static unsigned long acct;
static long cnt;
static char *qm;

static void init(unsigned long s, PAGENODE *p)
{
	SWAPNODE *ss;
	if (__unlikely(ACCT_IS_LDCACHE(p->account))) {
		if (!ACCT_IS_LDCACHE(s)) goto ok;
		if (p->account == s) goto ok;
		goto bad;
	}
	ss = ACCT_SWAPNODE(s);
	do if (__likely(ACCT_FROM_SWAPNODE(ss) == p->account)) goto ok; while ((ss = ss->parent));
	bad:
	KERNEL$SUICIDE("init: MISACCOUNTED PAGENODE, ACCT @ %lX %LX(%d), IN PG %lX %LX(%d), AT %s", p->account, !ACCT_IS_LDCACHE(p->account) ? ACCT_SWAPNODE(p->account)->jobname : 0, !ACCT_IS_LDCACHE(p->account) ? ACCT_SWAPNODE(p->account)->depth : 0, s, !ACCT_IS_LDCACHE(s) ? ACCT_SWAPNODE(s)->jobname : 0, !ACCT_IS_LDCACHE(s) ? ACCT_SWAPNODE(s)->depth : 0, qm);
	ok:
	p->swap_pos |= __LONG_SGN_BIT;
}

static void count(unsigned long s, PAGENODE *p)
{
	if (p->swap_pos & __LONG_SGN_BIT) {
		if (p->account == acct) cnt++;
		p->swap_pos &= ~__LONG_SGN_BIT;
	}
}

static void init_ref(SWAPNODE *s, LDREF *r)
{
}

static void count_ref(SWAPNODE *s, LDREF *r)
{
	if (ACCT_FROM_SWAPNODE(s) == acct) cnt += r->ldcache->pageq.q_node_usage;
}

static void check_quotaa(unsigned long s, char *msg, int n)
{
	qm = msg;
	cnt = 0;
	acct = s;
	dfs(s, init, init_ref);
	dfs(s, count, count_ref);
	if (__unlikely(cnt != ACCT_SWAPNODE(s)->pageq.q_node_usage))
		KERNEL$SUICIDE("check_qouta: QUOTA DOESN'T MATCH (%ld != %ld) AT %s PASS (%d)", cnt, ACCT_SWAPNODE(s)->pageq.q_node_usage, msg, n);
}

void check_quota(unsigned long s, char *msg)
{
	int i;
	SWAPNODE *ss;
	check_quotaa(s, msg, 1);
	if (__likely(!ACCT_IS_LDCACHE(s))) {
		if (__likely(ACCT_SWAPNODE(s)->parent != NULL)) check_quotaa(ACCT_FROM_SWAPNODE(ACCT_SWAPNODE(s)->parent), msg, 2);
		for (i = 0; i < CHILDHASH_SIZE; i++)
			XLIST_FOR_EACH_UNLIKELY(ss, &ACCT_SWAPNODE(s)->childhash[i], SWAPNODE, hash) check_quotaa(ACCT_FROM_SWAPNODE(ss), msg, 3);
	}
	check_quotaa(ACCT_FROM_SWAPNODE(root), msg, 4);
}

#endif

DECL_IOCALL(SWAP_PAGE_RELEASE, SPL_FS, PAGE_RELEASE_REQUEST)
{
	PAGENODE *pn;
	PAGE *p1 = RQ->pg;
	PAGE *p2;
	void *v1, *v2;
	if (__unlikely(p1->release != SWAP_PAGE_RELEASE)) {
		call_again:
		RETURN_IORQ_LSTAT(RQ, KERNEL$WAKE_PAGE_RELEASE);
	}
	if (__unlikely((unsigned)(unsigned long)p1->fnode & PAGE_FNODE_FREED)) {
		wqw:
		WQ_WAIT(&p1->wait, RQ, KERNEL$WAKE_PAGE_RELEASE);
		RETURN;
	}
	if (__unlikely(p1->flags & PAGE_WANTFREE)) {
		goto wqw;
	}
	if (__unlikely((KERNEL$VM_UNMAP_PAGE(p1)) != NULL)) {
		LOWER_SPL(SPL_FS);
		RQ->tmp1 = (unsigned long)KERNEL$WAKE_PAGE_RELEASE;
		if (SWAPOUT_PAGE(p1, (IORQ *)RQ, 0, &KERNEL$PROC_KERNEL)) RETURN;
		goto call_again;
	}
	if (!(p2 = KERNEL$ALLOC_USER_PAGE(VM_TYPE_WIRED_UNMAPPED))) {
		if (KERNEL$OOM(VM_TYPE_WIRED_UNMAPPED)) {
			RQ->status = -ENOMEM;
			RETURN_AST(RQ);
		}
		LOWER_SPL(SPL_FS);
		WQ_WAIT(&KERNEL$FREEMEM_WAIT, RQ, KERNEL$WAKE_PAGE_RELEASE);
		RETURN;
	}
	pn = p1->fnode;
	pn->page = NULL;
	LOWER_SPL(SPL_FS);
	p2->flags = PAGE_WRITEABLE;
	p2->release = SWAP_PAGE_RELEASE;
	p2->lockdown = SWAP_PAGE_LOCKDOWN;
	WQ_WAKE_ALL(&p1->wait);
	WQ_INIT(&p2->wait, "SWAPPER$PAGE_WAIT(rel)");
	DEL_FROM_LIST(&p1->node_entry);
	ADD_TO_LIST(&all_pages, &p2->node_entry);
	CACHE_CONSTRUCT_VM_ENTITY(&p2->e);
	RAISE_SPL(SPL_CACHE);
	p2->e.type = swap_vm_entity;
	KERNEL$CACHE_INSERT_VM_ENTITY(&p2->e, &KERNEL$PROC_KERNEL, 0);
	TEST_SPL(SPL_FS, SPL_CACHE);
	KERNEL$CACHE_TRANSFER_QUEUE_STATE(&p2->e, &p1->e);
	TEST_SPL(SPL_FS, SPL_CACHE);
	KERNEL$CACHE_REMOVE_VM_ENTITY(&p1->e);
	LOWER_SPL(SPL_FS);
	v1 = KERNEL$MAP_PHYSICAL_PAGE(p1);
	v2 = KERNEL$MAP_PHYSICAL_PAGE(p2);
	memcpy(v2, v1, PAGE_CLUSTER_SIZE);
	KERNEL$UNMAP_PHYSICAL_BANK(v1);
	KERNEL$UNMAP_PHYSICAL_BANK(v2);
	INIT_XLIST(&p2->mapping);
	p2->fnode = p1->fnode;
	RAISE_SPL(SPL_VSPACE);
	pn->page = p2;
	LOWER_SPL(SPL_FS);
	KERNEL$PAGE_RELEASE(p1, VM_TYPE_WIRED_UNMAPPED);
	RQ->status = 0;
	RETURN_AST(RQ);
}

#define WILL_COPY(wr)	(((wr) & (PF_WRITE | PF_SHARE)) == PF_WRITE)
#define MAKE_COPY(wr)	((wr) = ((wr) & ~PF_SHARE) | PF_WRITE)

#define DO_SWAPPER
#include "SWAPPND.I"

static PAGENODE *SWAP_ALLOC_PAGENODE(SWAPNODE *s)
{
	PAGENODE *pg;
	QUOTA *pzap;
	ASSERT_LOCKED();
	pg = __slalloc(&pagenodes);
	if (__unlikely(!pg)) {
		return (void *)(UNPAGED_ALLOC_FAILED() + 1);
	}
	QALLOC(&s->pageq, 1, pageq_isroot, pageq_parent, Q_NULL_CALL, pzap, {
		__slow_slfree(pg);
		OUT_OF_PAGED(pzap);
		return (void *)1;
	});
	pg->swap_pos = 0;
	pg->page = NULL;
	pg->refcount = 1;
	pg->account = ACCT_FROM_SWAPNODE(s);
	return pg;
}

void SWAP_FREE_PAGENODE(PAGENODE *pg)
{
	ASSERT_LOCKED();
#if __DEBUG >= 1
	if (__unlikely(pg->refcount != 1))
		KERNEL$SUICIDE("SWAP_FREE_PAGENODE: REFERENCE COUNT %ld", pg->refcount);
#endif
	QFREE(&ACCT_SWAPNODE(pg->account)->pageq, 1, pageq_isroot, pageq_parent, Q_NULL_CALL);
	__slfree(pg);
}

PAGE *SWAP_CREATE_PAGE(unsigned long s, unsigned long idx, int wr, IORQ *rq, PROC *owner)
{
	int err;
	PAGEDIR **n;
	PAGENODE *pn, *nnn;
	PAGE *p;
	WQ *wq;
	void *zret = NULL;
	if (__unlikely(ACCT_IS_LDCACHE(s))) {
		if (__unlikely((wr & (PF_SWAPPER | PF_SHARE)) != (PF_SWAPPER | PF_SHARE)))
			KERNEL$SUICIDE("SWAP_CREATE_PAGE: AN ATTEMPT TO MODIFY LDCACHE, WR %X", wr);
	} else {
		if (__unlikely(wr & PF_SWAPPER)) owner = &KERNEL$PROC_KERNEL;
	}
	check_quota(s, "SWAP_CREATE_PAGE 1");
	if (__unlikely(idx >= VMSPACE)) {
		err = -ERANGE;
		ret_err:
			/* !!! FIXME: remove, just testing */
		if (!rq) KERNEL$STACK_DUMP();
		KERNEL$SYSLOG(__SYSLOG_SW_WARNING, "SYS$SWAPPER", "ERROR AT ADDRESS %lX, ACCESS %d: %s (POSTING %p)", idx, wr, strerror(-err), rq ? rq->fn : NULL);
		if (rq) {
			rq->status = err;
			CALL_AST(rq);
		}
		return NULL;
	}
	SWAP_LOCK(SW_LOCK);
	repeat_lookup:
	n = SWAP_RETURN_PAGENODE(ACCT_SWAPNODE(s), idx, &wr);
	if (__unlikely((unsigned long)n <= 2)) {
		alloc_fail:
		SWAP_LOCK(SW_UNLOCK);
		if (__unlikely(!n)) {
			if (__unlikely(rq != NULL))
				KERNEL$SUICIDE("SWAP_CREATE_PAGE: GET_PAGEIN_RQ CALLED WITH PF_TESTPAGE");
		} else if (__unlikely(n == (void *)1)) {
			if (rq) CALL_IORQ_LSTAT_EXPR(rq, (IO_STUB *)rq->tmp1);
		} else {
			if (rq) WQ_WAIT_F(&KERNEL$FREEMEM_WAIT, rq);
		}
	check_quota(s, "SWAP_CREATE_PAGE 2");
		return zret;
	}
	if (__unlikely(__IS_ERR(n))) {
		err = __PTR_ERR(n);
		__debug_printf("x1\n");	/* !!! FIXME */
		unlock_ret_err:
		SWAP_LOCK(SW_UNLOCK);
		goto ret_err;
	}
	if (__unlikely(!(pn = (PAGENODE *)*n))) {
		if (__unlikely(wr & PF_TESTPAGE)) {
			SWAP_LOCK(SW_UNLOCK);
	check_quota(s, "SWAP_CREATE_PAGE 3");
			return NULL;
		}
		if (__unlikely(wr & PF_SWAPPER)) {
			err = -EINVAL;
			__debug_printf("inval 1\n"); /* !!! FIXME */
			goto unlock_ret_err;
		}
		if (__unlikely(!WILL_COPY(wr))) {
			MAKE_COPY(wr);
			goto repeat_lookup;
		}
		pn = SWAP_ALLOC_PAGENODE(ACCT_SWAPNODE(s));
		if (__unlikely((unsigned long)pn <= 2)) {
			n = (void *)pn;
			goto alloc_fail;
		}
		*n = (PAGEDIR *)pn;
	} else {
#if __DEBUG >= 1
		if (__unlikely(!pn->page) && __unlikely(!pn->swap_pos))
			KERNEL$SUICIDE("SWAP_CREATE_PAGE: EMPTY PAGENODE");
#endif
		if (__unlikely(wr & PF_SHARE) && __unlikely(ACCT_IS_LDCACHE(pn->account)) && __unlikely(!ACCT_IS_LDCACHE(s))) {
			err = -EINVAL;
			__debug_printf("inval 2\n"); /* !!! FIXME */
			goto unlock_ret_err;
		}
	}
	p = pn->page;
	if (__unlikely(!p)) {
		if (__unlikely(wr & PF_TESTPAGE)) {
			SWAP_LOCK(SW_UNLOCK);
	check_quota(s, "SWAP_CREATE_PAGE 4");
			return (void *)!!pn->swap_pos;
		}
		if (__unlikely((wq = KERNEL$MAY_DIRTY(owner, 0)) != NULL) || __unlikely((wq = KERNEL$MAY_ALLOC(owner, PAGE_CLUSTER_SIZE)) != NULL)) {
			if (!pn->swap_pos) {
				SWAP_FREE_PAGENODE(pn);
				*n = NULL;
			}
			SWAP_LOCK(SW_UNLOCK);
			if (rq) WQ_WAIT_F(wq, rq);
			return NULL;
		}
		if (__unlikely(pn->swap_pos != 0)) {
			SWAP_LOCK(SW_UNLOCK);
			SWAPIN(pn, rq, owner, wr);
	check_quota(s, "SWAP_CREATE_PAGE 5");
			return NULL;
		}
/* PF_SWAPPER shouldn't be set here because empty pagenodes are forbidden */
		p = PAGEZONE_ALLOC(&pagezone, KERNEL$ALLOC_USER_PAGE, EMERGENCY_RESERVE_PAGES);
		if (__unlikely(!p)) {
			SWAP_FREE_PAGENODE(pn);
			*n = NULL;
			SWAP_LOCK(SW_UNLOCK);
			SWAPOUT(rq);
	check_quota(s, "SWAP_CREATE_PAGE 6");
			return NULL;
		}
		if (__unlikely(wr & PF_WAIT_4_ALLOC)) {
			SWAP_FREE_PAGENODE(pn);
			*n = NULL;
			PAGEZONE_FREE(&pagezone, p, EMERGENCY_RESERVE_PAGES);
			SWAP_LOCK(SW_UNLOCK);
			if (rq) CALL_IORQ_LSTAT_EXPR(rq, (IO_STUB *)rq->tmp1);
	check_quota(s, "SWAP_CREATE_PAGE 7");
			return NULL;
		}
		setup_node_page(p, pn, owner);
		if (__likely(!(wr & PF_COW))) {
			void *v = KERNEL$MAP_PHYSICAL_PAGE(p);
			memset(v, 0, PAGE_CLUSTER_SIZE);
			KERNEL$UNMAP_PHYSICAL_BANK(v);
		}
	} else {
		if (__unlikely(wr & PF_TESTPAGE)) zret = (void *)1;
		if (__unlikely(p->flags & PAGE_BUSY)) {
			if (rq) WQ_WAIT_F(&p->wait, rq);
			SWAP_LOCK(SW_UNLOCK);
	check_quota(s, "SWAP_CREATE_PAGE 8");
			return zret;
		}
		if (__unlikely(wr & PF_WRITE)) {
			if (__unlikely(pn->refcount > 1) && __likely(!(wr & PF_SHARE))) {
				void *v1, *v2;
				PAGE *p2;
				if (__unlikely(wr & PF_SWAPPER)) {
					err = -EINVAL;
					goto unlock_ret_err;
				}
				nnn = SWAP_ALLOC_PAGENODE(ACCT_SWAPNODE(s));
				if (__unlikely((unsigned long)nnn <= 2)) {
					n = (void *)nnn;
					goto alloc_fail;
				}
				if (__unlikely((wq = KERNEL$MAY_DIRTY(owner, 0)) != NULL) || __unlikely((wq = KERNEL$MAY_ALLOC(owner, PAGE_CLUSTER_SIZE)) != NULL)) {
					if (rq) WQ_WAIT_F(wq, rq);
					SWAP_FREE_PAGENODE(nnn);
					SWAP_LOCK(SW_UNLOCK);
					return zret;
				}
				p2 = PAGEZONE_ALLOC(&pagezone, KERNEL$ALLOC_USER_PAGE, EMERGENCY_RESERVE_PAGES);
				if (__unlikely(!p2)) {
					SWAP_FREE_PAGENODE(nnn);
					SWAP_LOCK(SW_UNLOCK);
					SWAPOUT(rq);
	check_quota(s, "SWAP_CREATE_PAGE 9");
					return zret;
				}
				if (__unlikely(wr & PF_WAIT_4_ALLOC)) {
					PAGEZONE_FREE(&pagezone, p2, EMERGENCY_RESERVE_PAGES);
					SWAP_FREE_PAGENODE(nnn);
					if (rq) CALL_IORQ_LSTAT_EXPR(rq, (IO_STUB *)rq->tmp1);
					SWAP_LOCK(SW_UNLOCK);
	check_quota(s, "SWAP_CREATE_PAGE 10");
					return zret;
				}
	/* warning, we must FIRST copy content and THEN subtract refcount
	   ... REFERENCE_LDCACHE may actually free source page */
				setup_node_page(p2, nnn, owner);
				v1 = KERNEL$MAP_PHYSICAL_PAGE(p);
				v2 = KERNEL$MAP_PHYSICAL_PAGE(p2);
				memcpy(v2, v1, PAGE_CLUSTER_SIZE);
				KERNEL$UNMAP_PHYSICAL_BANK(v1);
				KERNEL$UNMAP_PHYSICAL_BANK(v2);
				pn->refcount--;
				if (__unlikely(ACCT_IS_LDCACHE(pn->account))) REFERENCE_LDCACHE(ACCT_SWAPNODE(s), pn->account, -1, owner);
				*n = (PAGEDIR *)nnn;
				p = p2;
				pn = nnn;
			} else if (__unlikely(pn->swap_pos != 0)) {
				CLEAR_SWPALLOC_BIT(pn->swap_pos);
				pn->swap_pos = 0;
			}
		}
	}
	DEL_FROM_LIST(&p->node_entry);
	ADD_TO_LIST(&all_pages, &p->node_entry);
	SWAP_LOCK(SW_UNLOCK);
	check_quota(s, "SWAP_CREATE_PAGE 11");
	return p;
}

PAGE *SWAP_GET_PAGE(HANDLE *h, __v_off idx, int wr)
{
	PAGE *p;
	SWAPNODE *swapnode = h->fnode;
	if (__unlikely(swapnode == root)) {
		return NULL;
	}
	if (__unlikely(idx != (unsigned long)idx)) {
		return NULL;
	}
	check_quota(ACCT_FROM_SWAPNODE(swapnode), "SWAP_GET_PAGE 1");
	p = SWAP_CREATE_PAGE(ACCT_FROM_SWAPNODE(swapnode), idx, wr, NULL, h->name_addrspace);
	check_quota(ACCT_FROM_SWAPNODE(swapnode), "SWAP_GET_PAGE 2");
	if (__unlikely((unsigned long)p <= 1)) {
		return p;
	}
	RAISE_SPL(SPL_CACHE);
	KERNEL$CACHE_TOUCH_VM_ENTITY(&p->e, h->name_addrspace);
	LOWER_SPL(SPL_FS);
#if __DEBUG >= 1
	if (__unlikely(p->flags & PAGE_BUSY))
		KERNEL$SUICIDE("SWAP_GET_PAGE: BUSY PAGE RETURNED, FLAGS %X", p->flags);
#endif
	return p;
}

int SWAP_SWAP_OP(HANDLE *h, int op, ...)
{
	PROC *proc;
	int r;
	unsigned long from, len;
	char *forkname;
	SWAPNODE *n;
	va_list va;
	va_start(va, op);
	switch (op) {
		case SWAP_OP_ZAP_PAGES:
			from = va_arg(va, __v_off);
			len = va_arg(va, __v_off);
			proc = va_arg(va, PROC *);
			SWAP_LOCK(SW_LOCK);
			r = (int)SWAP_DESTROY_DATA(h->fnode, from, from + len, proc);
			SWAP_LOCK(SW_UNLOCK);
			break;
		case SWAP_OP_FORK:
			forkname = va_arg(va, char *);
			n = SWAP_FIND_NODE(h->fnode, forkname);
			if (__unlikely(__IS_ERR(n))) {
				r = __PTR_ERR(n);
				break;
			}
			SWAP_FORK(h->fnode, n);
			r = 0;
			break;
		default:
			KERNEL$SUICIDE("SWAP_SWAP_OP: INVALID OPERATION %d", op);
	}
	va_end(va);
	return r;
}

static IORQ * volatile pagein_rq = NULL;
static VDESC pagein_vdesc;
static int pagein_wr;
static IORQ pagein_io;
static WQ_DECL(pagein_wait, "SWAPPER$PAGEIN_WAIT");

extern IO_STUB SWAP_PAGEIN_RQ_CONT;

IORQ *SWAP_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int wr)
{
	if (__unlikely(pagein_rq != NULL)) {
		WQ_WAIT_F(&pagein_wait, rq);
		return NULL;
	}
#if __DEBUG >= 1
	if (__unlikely(wr & PF_TESTPAGE)) KERNEL$SUICIDE("SWAP_GET_PAGEIN_RQ: wr %X", wr);
#endif
	pagein_rq = rq;
	memcpy(&pagein_vdesc, desc, sizeof(VDESC));
	pagein_wr = wr;
	pagein_io.tmp1 = (unsigned)SWAP_PAGEIN_RQ_CONT;
	return &pagein_io;
}

DECL_IOCALL(SWAP_PAGEIN_RQ_CONT, SPL_FS, IORQ)
{
	IORQ *caller;
	PAGE *p;
	SWAPNODE *node;
	unsigned long addr;
	if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) {
		/* WQ_WAIT_F(&KERNEL$LOCKUP_EVENTS, pagein_rq);
		goto ret; --- this would livelock */
		WQ_WAIT_F(&KERNEL$LOCKUP_EVENTS, RQ);
		RETURN;
	}
	SWITCH_PROC_ACCOUNT(pagein_vdesc.vspace->name_addrspace, SPL_X(SPL_FS));
	if (__unlikely(pagein_vdesc.ptr != (unsigned long)pagein_vdesc.ptr)) {
		pagein_rq->status = -ERANGE;
		err:
		caller = pagein_rq;
		RAISE_SPL(SPL_VSPACE);
		pagein_rq = NULL;
		WQ_WAKE_ALL(&pagein_wait);
		RETURN_AST(caller);
	}
	if (__unlikely(!(pagein_wr & PF_PAGEIO))) {
		pagein_rq->status = -ENOVSPACE;
		goto err;
	}
	if (__unlikely(pagein_vdesc.vspace->op != &SWAP_OPERATIONS)) goto xx;
	node = pagein_vdesc.vspace->fnode;
	if (__unlikely(node == root)) {
		pagein_rq->status = -EINVAL;
		goto err;
	}
	addr = pagein_vdesc.ptr;

	nextpage:
	check_quota(ACCT_FROM_SWAPNODE(node), "SWAP_PAGEIN_RQ_CONT 1");
	p = SWAP_CREATE_PAGE(ACCT_FROM_SWAPNODE(node), addr, pagein_wr & (PF_WRITE | PF_WAIT_4_ALLOC | PF_SWAPPER | PF_SHARE), pagein_rq, pagein_vdesc.vspace->name_addrspace);
	check_quota(ACCT_FROM_SWAPNODE(node), "SWAP_PAGEIN_RQ_CONT 2");
	if (p) {
		unsigned x;
		RAISE_SPL(SPL_CACHE);
		KERNEL$CACHE_TOUCH_VM_ENTITY(&p->e, pagein_vdesc.vspace->name_addrspace);
		LOWER_SPL(SPL_FS);
		if (__unlikely((p->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) {
			WQ_WAIT_F(&p->wait, pagein_rq);
			goto ret;
		}
		x = PAGE_CLUSTER_SIZE - (addr & (PAGE_CLUSTER_SIZE - 1));
		if (x < pagein_vdesc.len) {
			addr += x;
			pagein_vdesc.len -= x;
			goto nextpage;
		}
		goto xx;
	}
	ret:
	RAISE_SPL(SPL_VSPACE);
	pagein_rq = NULL;
	WQ_WAKE_ALL(&pagein_wait);
	RETURN;

	xx:
	caller = pagein_rq;
	RAISE_SPL(SPL_VSPACE);
	pagein_rq = NULL;
	WQ_WAKE_ALL(&pagein_wait);
	RETURN_IORQ_LSTAT(caller, (IO_STUB *)caller->tmp1);
}

WQ *SWAP_PAGE_LOCKDOWN(PAGE *p, int lock)
{
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_VSPACE)))
		KERNEL$SUICIDE("SWAP_PAGE_LOCKDOWN AT SPL %08X", KERNEL$SPL);
#endif
	if (!lock) {
		/*
		This is not needed because we do not touch pagenode tree
		if (__unlikely(swap_lock)) return &swap_lock_wq;
		*/
		if (__unlikely(p->flags & (PAGE_BUSY | PAGE_WANTFREE))) return &p->wait;
		if (__unlikely((p->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) return &p->wait;
		p->flags += PAGE_DMALOCKCOUNT_1;
		return NULL;
	} else {
#if __DEBUG >= 1
		if (__unlikely(!(p->flags & PAGE_DMALOCKCOUNT)))
			KERNEL$SUICIDE("SPAD_PAGE_LOCKDOWN: UNLOCKING UNLOCKED PAGE, FLAGS %X", p->flags);
#endif
		if (__unlikely((p->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) WQ_WAKE_ALL(&p->wait);
		if (__likely(!((p->flags -= PAGE_DMALOCKCOUNT_1) & PAGE_DMALOCKCOUNT))) WQ_WAKE_ALL(&p->wait);
		return NULL;
	}
}

int SWAP_CHECKMAP(VMENTITY *e)
{
	PAGE *p;
	LOWER_SPL(SPL_FS);
	p = LIST_STRUCT(e, PAGE, e);
	return KERNEL$VM_SCAN_PAGE(p);
}

void SWAP_WRITE(VMENTITY *e, PROC *proc, int trashing)
{
	PAGE *p;
	PAGENODE *pn;
	LOWER_SPL(SPL_FS);
	if (__likely(!trashing)) return;
	p = LIST_STRUCT(e, PAGE, e);
	pn = p->fnode;
	if (__unlikely((unsigned)(unsigned long)pn & PAGE_FNODE_FREED)) return;
	if (__unlikely(pn->swap_pos)) return;
	SWAPOUT_PAGE(p, NULL, 0, proc);
}

int SWAP_SWAPOUT(VMENTITY *e)
{
	PAGE *p;
	LOWER_SPL(SPL_FS);
	p = LIST_STRUCT(e, PAGE, e);
	if (__unlikely(!pagezone.allocated)) return 2;
	return SWAPOUT_PAGE(p, NULL, 1, &KERNEL$PROC_KERNEL);
}

