#if defined(DO_SWAPPER)
__finline__ PAGEDIR **SWAP_RETURN_PAGENODE(SWAPNODE *s, unsigned long idx, int *wr)
#elif defined(DO_LDCACHE)
static __finline__ PAGEDIR **SWAPLD_RETURN_PAGENODE(LDCACHE *s, unsigned long idx, SWAPNODE *acct)
#elif defined(DO_SIMPLE)
__finline__ PAGENODE *SWAP_SIMPLE_RETURN_PAGENODE(SWAPNODE *s, unsigned long idx)
#else
ERROR
#endif
{
	int i, j, sh;
	PAGEDIR **pos;
	idx >>= PG_SIZE_BITS + PG_CLUSTER_BITS;
#if defined(DO_SWAPPER)
	again:
#endif
	i = idx / PGDIR_DIV;
	if (__unlikely(i >= TOP_PGDIR_SIZE))
		KERNEL$SUICIDE("SWAP_RETURN_PAGENODE: INDEX %lX TOO LARGE", idx);
	pos = &s->pagedir[i];
	sh = PGDIR_DIV_BITS;
	for (j = 0; j < PGDIR_DEPTH; j++) {
		PAGEDIR *pgdir;
		if (__unlikely(!(pgdir = *pos))) {
#if defined(DO_SIMPLE)
			return NULL;
#else
			QUOTA *pzap;
#if defined(DO_SWAPPER)
			if (__unlikely(*wr & PF_TESTPAGE)) return NULL;
			if (__unlikely(*wr & PF_SWAPPER)) return __ERR_PTR(-EINVAL);
			if (__unlikely(!WILL_COPY(*wr))) {
				MAKE_COPY(*wr);
				goto again;
			}
#endif
			pgdir = __slalloc(&pagedirs);
			if (__unlikely(!pgdir)) {
				return (void *)(UNPAGED_ALLOC_FAILED() + 1);
			}
#if defined(DO_SWAPPER)
			QALLOC(&s->unpageq, sizeof(PAGEDIR), unpageq_isroot, unpageq_parent, Q_NULL_CALL, pzap, {
				__slow_slfree(pgdir);
				OUT_OF_UNPAGED(pzap);
				return (void *)1;
			});
#else
			QALLOC(&acct->unpageq, sizeof(PAGEDIR), unpageq_isroot, unpageq_parent, Q_NULL_CALL, pzap, {
				__slow_slfree(pgdir);
				OUT_OF_UNPAGED(pzap);
				return (void *)1;
			});
			QALLOC(&s->unpageq, sizeof(PAGEDIR), isroot_1, unpageq_parent, Q_NULL_CALL, pzap, {
				KERNEL$SUICIDE("SWAP_RETURN_PAGENODE: QALLOC ON LDCACHE FAILED");
			});
#endif
#if __DEBUG >= 2
			{
				int k;
				for (k = 0; k < PGDIR_SIZE; k++) if (__unlikely(pgdir->pagedir[i] != NULL)) KERNEL$SUICIDE("SWAP_RETURN_PAGENODE: PAGEDIR NOT CONSTRUCTED");
			}
#endif
			pgdir->refcount = 1;
#if defined(DO_SWAPPER)
			pgdir->account = ACCT_FROM_SWAPNODE(s);
#else
			pgdir->account = ACCT_FROM_LDCACHE(s);
#endif
			*pos = pgdir;
#if defined(DO_SWAPPER)
		} else if (__unlikely(pgdir->refcount != 1) && WILL_COPY(*wr)) {
			void *v;
			if (__unlikely(*wr & PF_SWAPPER)) return __ERR_PTR(-EINVAL);
			if (__unlikely((v = COPY_PAGEDIR(pos, s)) != NULL))
				return v;
			pgdir = *pos;
#endif
#endif	/* defined(DO_SIMPLE) */
		}
		sh -= PGDIR_SIZE_BITS;
		i = (idx >> sh) & (PGDIR_SIZE - 1);
		pos = &pgdir->pagedir[i];
	}
#if !defined(DO_SIMPLE)
	return pos;
#else
	return (PAGENODE *)*pos;
#endif
}

#ifdef DO_SWAPPER
#undef DO_SWAPPER
#endif
#ifdef DO_LDCACHE
#undef DO_LDCACHE
#endif
#ifdef DO_SIMPLE
#undef DO_SIMPLE
#endif
