#include <SPAD/PCI.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYSLOG.H>
#include <ARCH/IO.H>

#include "EHCIBUST.H"
#include "EHCIREG.H"

static char *BUST_ONE_CONTROLLER(__const__ void *table, pci_id_t id, unsigned long *driver_data)
{
	__u8 *mem;
	if (__likely(!PCI$TEST_LIST(table, id, driver_data))) return NULL;
	mem = PCI$MAP_MEM_RESOURCE(id, 0, EHCI_REGSPACE);
	if (!mem || __IS_ERR(mem)) return NULL;
	/*__debug_printf("found @ %04X\n", id);
	__debug_printf("caplength: %02x\n", mmio_inb(mem + EHCI_CAPLENGTH));
	__debug_printf("hciversion: %04x\n", mmio_inw(mem + EHCI_HCIVERSION));
	__debug_printf("hcsparams: %08x\n", mmio_inl(mem + EHCI_HCSPARAMS));
	__debug_printf("hccparams: %08x\n", mmio_inl(mem + EHCI_HCCPARAMS));
	__debug_printf("hcsp-portroute: %08x\n", mmio_inl(mem + EHCI_HCSP_PORTROUTE));*/
	if (EHCI_TAKEOVER(id, mem)) goto failed;

	failed:
	PCI$UNMAP_MEM_RESOURCE(id, mem, EHCI_REGSPACE);
	return NULL;
}

void BUST_EHCI(void)
{
	PCI$FIND_DEVICE(EHCI_PCI, 0, 0, 0, BUST_ONE_CONTROLLER, NULL, NULL, NULL, 0);
}
