#include <SPAD/SYNC.H>
#include <SPAD/PCI.H>
#include <ARCH/IO.H>
#include <ARCH/BSF.H>
#include <SPAD/SYSLOG.H>
#include <ARCH/TIME.H>

#include "EHCIBUST.H"

#include "EHCIREG.H"

#define TAKEOVER_TIMEOUT	300
#define RESET_TIMEOUT		250

#define TAKEOVER_BUGS

__const__ struct pci_id_s EHCI_PCI[] = {
	{ PCI_ANY_ID, PCI_ANY_ID, PCI_ANY_ID, PCI_ANY_ID, (PCI_CLASS_SERIAL_USB << 16) | (0x20 << 8), 0xFFFFFF00U, "EHCI", 0 },
	{ 0 },
};

int EHCI_TAKEOVER(pci_id_t id, __u8 *mem)
{
	__u8 *op_mem;
	char str[__MAX_STR_LEN];
	unsigned timeout;
	unsigned op_offset;
	__u32 hccparams = mmio_inl(mem + EHCI_HCCPARAMS);
	int legacy_space = PCI$FIND_CAPABILITY(id, (hccparams & EHCI_HCCPARAMS_EECP) >> __BSF_CONST(EHCI_HCCPARAMS_EECP), EHCI_EECP_BIOS_SYNC);
	__u32 ctl1 = PCI$READ_CONFIG_DWORD(id, legacy_space + EHCI_USBLEGSTSCTLS);
	/*__debug_printf("legacy space: %d, %08X, %08X\n", legacy_space, PCI$READ_CONFIG_DWORD(id, legacy_space), PCI$READ_CONFIG_DWORD(id, legacy_space + 4));*/
	if (legacy_space < 0) return 0;
#ifdef TAKEOVER_BUGS
	if (PCI$READ_CONFIG_BYTE(id, legacy_space + EHCI_USBLEGSUP_OS_SEM) == 1 && PCI$READ_CONFIG_BYTE(id, legacy_space + EHCI_USBLEGSUP_BIOS_SEM))
		PCI$WRITE_CONFIG_BYTE(id, legacy_space + EHCI_USBLEGSUP_OS_SEM, 0);
#endif
	PCI$WRITE_CONFIG_BYTE(id, legacy_space + EHCI_USBLEGSUP_OS_SEM, 1);
	timeout = 0;
	while (PCI$READ_CONFIG_BYTE(id, legacy_space + EHCI_USBLEGSUP_BIOS_SEM)) {
		if (++timeout > TAKEOVER_TIMEOUT) {
			__u32 ctl = PCI$READ_CONFIG_DWORD(id, legacy_space + EHCI_USBLEGSTSCTLS);
#ifdef TAKEOVER_BUGS
			if ((ctl & (EHCI_USBLEGSTSCTLS_SMI_OS_OWNER | EHCI_USBLEGSTSCTLS_EN_SMI_OS_OWNER)) == (EHCI_USBLEGSTSCTLS_SMI_OS_OWNER | EHCI_USBLEGSTSCTLS_EN_SMI_OS_OWNER)) {
	/* This means that SMI routing doesn't work */
	/* It happens on ASUS ICH7 mainboard after a power cycle. It doesn't
	   happen after reset */
				KERNEL$SYSLOG(__SYSLOG_HW_BUG, "EHCI", "%s: FORCED TAKEOVER, SMI ROUTING DOESN'T WORK (USBLEGSTSCTLS %08X)", PCI$ID(str, id), (unsigned)ctl);
				forced_takeover:
				PCI$WRITE_CONFIG_DWORD(id, legacy_space + EHCI_USBLEGSTSCTLS, EHCI_USBLEGSTSCTLS_SMI_COMPLETE | EHCI_USBLEGSTSCTLS_SMI_ERROR | EHCI_USBLEGSTSCTLS_SMI_PORT_CHANGE | EHCI_USBLEGSTSCTLS_SMI_FL_ROLLOVER | EHCI_USBLEGSTSCTLS_SMI_SYS_ERROR | EHCI_USBLEGSTSCTLS_SMI_ASYNC_ADV | EHCI_USBLEGSTSCTLS_SMI_OS_OWNER | EHCI_USBLEGSTSCTLS_SMI_PCI_COMMAND | EHCI_USBLEGSTSCTLS_SMI_BAR_ENABLE);
				PCI$WRITE_CONFIG_BYTE(id, legacy_space + EHCI_USBLEGSUP_BIOS_SEM, 0);
				goto reset_it;
			}
			if (!(ctl1 & EHCI_USBLEGSTSCTLS_EN_SMI_OS_OWNER) && ctl & EHCI_USBLEGSTSCTLS_SMI_OS_OWNER) {
	/* This happens on ASUS mainboard with VIA chipset. It seems that the
	   BIOS doesn't care at all about takeover, it doesn't even set
	   appropriate bit. I hope that it gives up control after we clear
	   USBLEGSTSCTLS */
				KERNEL$SYSLOG(__SYSLOG_HW_BUG, "EHCI", "%s: FORCED TAKEOVER, BIOS DOESN'T CARE (USBLEGSTSCTLS %08X)", PCI$ID(str, id), (unsigned)ctl);
				goto forced_takeover;
			}
#endif
			KERNEL$SYSLOG(__SYSLOG_HW_BUG, "EHCI", "%s: TAKEOVER FAILED (USBLEGSTSCTLS %08X)", PCI$ID(str, id), (unsigned)ctl);
			return -EIO;
		}
		KERNEL$UDELAY(1000);
		TEST_LOCKUP_SYNC;
	}

	reset_it:
	op_offset = mmio_inb(mem + EHCI_CAPLENGTH);
	if (__unlikely(op_offset + EHCIOP_PORTSC >= EHCI_REGSPACE)) {
		KERNEL$SYSLOG(__SYSLOG_HW_BUG, "EHCI", "%s: INVALID OPERATIONAL OFFSET: %02X", PCI$ID(str, id), op_offset);
		return -EINVAL;
	}
	op_mem = mem + op_offset;
	mmio_outl(op_mem + EHCIOP_USBINTR, 0);
	mmio_outl(op_mem + EHCIOP_USBCMD, mmio_inl(op_mem + EHCIOP_USBCMD) & ~EHCIOP_USBCMD_RUN_STOP);
	timeout = 0;
	while (!(mmio_inl(op_mem + EHCIOP_USBSTS) & EHCIOP_USBSTS_HALTED)) {
		if (++timeout > 25) {
			KERNEL$SYSLOG(__SYSLOG_HW_BUG, "EHCI", "%s: HALT FAILED (USBCMD %08X, USBSTS %08X)", PCI$ID(str, id), (unsigned)mmio_inl(op_mem + EHCIOP_USBCMD), (unsigned)mmio_inl(op_mem + EHCIOP_USBSTS));
			mmio_outl(op_mem + EHCIOP_CONFIGFLAG, 0);
			return -EIO;
		}
		KERNEL$UDELAY(100);
		TEST_LOCKUP_SYNC;
	}
	mmio_outl(op_mem + EHCIOP_USBCMD, mmio_inl(op_mem + EHCIOP_USBCMD) | EHCIOP_USBCMD_HCRESET);
	timeout = 0;
	while (mmio_inl(op_mem + EHCIOP_USBCMD) & EHCIOP_USBCMD_HCRESET) {
		if (++timeout > RESET_TIMEOUT) {
			KERNEL$SYSLOG(__SYSLOG_HW_BUG, "EHCI", "%s: RESET FAILED (USBCMD %08X, USBSTS %08X)", PCI$ID(str, id), (unsigned)mmio_inl(op_mem + EHCIOP_USBCMD), (unsigned)mmio_inl(op_mem + EHCIOP_USBSTS));
			mmio_outl(op_mem + EHCIOP_CONFIGFLAG, 0);
			return -EIO;
		}
		KERNEL$UDELAY(1000);
		TEST_LOCKUP_SYNC;
	}
	mmio_outl(op_mem + EHCIOP_CONFIGFLAG, 0);

	return 0;
}
