#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <SPAD/SYSLOG.H>
#include <STDLIB.H>
#include <STRING.H>

#include <SPAD/USB.H>
#include <SPAD/USBHUB.H>

int main(int argc, char *argv[])
{
	int r;
	USB_ARGS *args = NULL;
	char **arg = argv;
	char *opt, *optend, *str;
	int state = 0;
	USB_DEV_INTERFACE *iface, *iface2;
	struct __param_table params[] = {
		NULL, 0, 0, 0, NULL,
	};
	if (__unlikely(__parse_params(&arg, &state, params, &opt, &optend, &str))) {
		if (__unlikely(USB$PARSE_PARAMS(opt, optend, str, &args))) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "USBHUB: SYNTAX ERROR");
			r = -EBADSYN;
			goto ret0;
		}
	}
	if (__IS_ERR(iface = USB$ATTACH_DRIVER(args, USB$HUB_TEST, USB_HUB_PROTOCOL_MULTIPLE_TT))) {
		if (!__IS_ERR(iface2 = USB$ATTACH_DRIVER(args, USB$HUB_TEST, USB_HUB_PROTOCOL_SINGLE_TT))) {
			iface = iface2;
			goto have_iface;
		}
		if (iface == __ERR_PTR(-ENODEV)) iface = iface2;
		r = __PTR_ERR(iface);
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "USBHUB: %s", strerror(-r));
		goto ret0;
	}
	have_iface:
	RAISE_SPL(SPL_USB);
	r = USB$HUB_ATTACH(iface);
	LOWER_SPL(SPL_ZERO);
	if (__unlikely(r)) {
		/* driver is detached automatically by USB$HUB_ATTACH here */
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "USBHUB: CAN'T ATTACH HUB: %s", strerror(-r));
		goto ret0;
	}

	ret0:
	USB$FREE_PARAMS(args);
	return r;
}
