#include <STDLIB.H>
#include <STDARG.H>
#include <STRING.H>
#include <SPAD/SYNC.H>
#include <SPAD/LIBC.H>

#include <SPAD/SHELL.H>

#include "USB.H"

char *USB$HC_DEFAULT_PLUG_SCRIPT = "LIB.:/USBPLUG.CMD";

typedef struct {
	LIST_ENTRY list;
	SHRCRQ shrcrq;
	USB *usb;
	char code[1];
} EVENT;

extern AST_STUB RUN_CODE_DONE;

static EVENT *USB_ALLOC_CODE(USB *usb, ...)
{
	SHCCRQ shccrq;
	EVENT *e;
	va_list args;
	size_t len;
	char *s, *ptr;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USB_RUN_CODE AT SPL %08X", KERNEL$SPL);
	len = 0;
	va_start(args, usb);
	while ((s = va_arg(args, char *))) len += strlen(s);
	va_end(args);
	e = __sync_malloc(sizeof(EVENT) + len);
	if (__unlikely(!e)) return __ERR_PTR(-ENOMEM);
	e->usb = usb;
	ptr = e->code;
	va_start(args, usb);
	while ((s = va_arg(args, char *))) ptr = stpcpy(ptr, s);
	va_end(args);
	SYNC_IO_CANCELABLE(&shccrq, SHELL$CREATE_CONTEXT);
	if (__unlikely(shccrq.status < 0)) {
		__slow_free(e);
		return __ERR_PTR(shccrq.status);
	}
	e->shrcrq.fn = RUN_CODE_DONE;
	e->shrcrq.ctx = shccrq.ctx;
	e->shrcrq.ptr = e->code;
	e->shrcrq.len = strlen(e->code);
	e->shrcrq.narg = 0;
	e->shrcrq.arg = NULL;
	return e;
}

static void USB_RUN_CODE(EVENT *e)
{
	USB *usb = e->usb;
	ADD_TO_XLIST(&usb->running, &e->list);
	CALL_IORQ(&e->shrcrq, SHELL$RUN_COMMANDS);
}

DECL_AST(RUN_CODE_DONE, SPL_USB, SHRCRQ)
{
	EVENT *e = GET_STRUCT(RQ, EVENT, shrcrq);
	DEL_FROM_LIST(&e->list);
	SHELL$DESTROY_CONTEXT(e->shrcrq.ctx);
	free(e);
	RETURN;
}

void USBPLUG_EVENT(USB_DEV *dev)
{
	EVENT *e;
	char addr[4];
	if (__unlikely(!*dev->usb->plug)) return;
	_snprintf(addr, sizeof addr, "%d", dev->addr);
	e = USB_ALLOC_CODE(dev->usb, "LET CTRL=\"", dev->usb->dev_name, "\"; LET ADDRESS=\"", addr, "\"; CALL ", dev->usb->plug, NULL);
	if (__unlikely(__IS_ERR(e))) return;
	USB_RUN_CODE(e);
}

int USBPLUG_ONUNPLUG(USB *usb, int addr, char **argv)
{
	USB_DEV *dev;
	EVENT *e;
	size_t len;
	char *cmd, *ptr;
	unsigned i;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_ONUNPLUG AT SPL %08X", KERNEL$SPL);
	len = strlen(argv[0]);
	for (i = 1; argv[i]; i++) len += 1 + strlen(argv[i]);
	cmd = __sync_malloc(len + 1);
	if (__unlikely(!cmd)) return -ENOMEM;
	ptr = stpcpy(cmd, argv[0]);
	for (i = 1; argv[i]; i++) ptr = stpcpy((*ptr++ = ' ', ptr), argv[i]);
	e = USB_ALLOC_CODE(usb, cmd, NULL);
	free(cmd);
	if (__unlikely(__IS_ERR(e))) return __PTR_ERR(e);
	dev = usb->devices[addr];
	if (__unlikely(!dev) || __unlikely(dev->hub_port == -1) || __unlikely(dev->n_attached == -1)) {
		USB_RUN_CODE(e);
		return 0;
	}
	ADD_TO_LIST_END(&dev->unplug, &e->list);
	return 0;
}

void USBPLUG_UNPLUG(USB_DEV *dev)
{
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_UNPLUG AT SPL %08X", KERNEL$SPL);
	while (!LIST_EMPTY(&dev->unplug)) {
		EVENT *e = LIST_STRUCT(dev->unplug.next, EVENT, list);
		DEL_FROM_LIST(&e->list);
		USB_RUN_CODE(e);
	}
}

void USBPLUG_PREPARE_UNLOAD(USB *usb)
{
	unsigned i;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_PREPARE_UNLOAD AT SPL %08X", KERNEL$SPL);
	for (i = 1; i < USB_MAX_ADDRESSES; i++) {
		USB_DEV *dev = i ? usb->devices[i] : &usb->root_hub;
		if (dev) USBPLUG_UNPLUG(dev);
	}
	while (__unlikely(!XLIST_EMPTY(&usb->running))) KERNEL$SLEEP(1);
}

void USBPLUG_UNLOAD(USB *usb)
{
	EVENT *e;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_UNLOAD AT SPL %08X", KERNEL$SPL);
	XLIST_FOR_EACH(e, &usb->running, EVENT, list) KERNEL$CIO((IORQ *)&e->shrcrq);
	while (__unlikely(!XLIST_EMPTY(&usb->running))) KERNEL$SLEEP(1);
}
