#include <STRING.H>
#include <SYS/UTSNAME.H>

#include <SPAD/USBHUB.H>

#include "USB.H"

/* descriptor copied from linux/drivers/usb/core/hcd.c
 * (C) Copyright Linus Torvalds 1999
 * (C) Copyright Johannes Erdfelt 1999-2001
 * (C) Copyright Andreas Gal 1999
 * (C) Copyright Gregory P. Smith 1999
 * (C) Copyright Deti Fliegl 1999
 * (C) Copyright Randy Dunlap 2000
 * (C) Copyright David Brownell 2000-2002
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static __const__ __u8 USB2_HUB_DEV_DESC[18] = {
	0x12,		/* __u8 bLength; */
	0x01,		/* __u8 bDescriptorType; Device */
	0x00, 0x02,	/* __le16 bcdUSB; v2.0 */

	0x09,		/* __u8 bDeviceClass; HUB_CLASSCODE */
	0x00,		/* __u8 bDeviceSubClass; */
	0x01,		/* __u8 bDeviceProtocol; [ usb 2.0 single TT ]*/
	0x08,		/* __u8 bMaxPacketSize0; 8 Bytes */

	0x00, 0x00,	/* __le16 idVendor; */
	0x00, 0x00,	/* __le16 idProduct; */
	0x02, 0x00,	/* __le16 bcdDevice */

	0x03,		/* __u8 iManufacturer; */
	0x02,		/* __u8 iProduct; */
	0x01,		/* __u8 iSerialNumber; */
	0x01		/* __u8 bNumConfigurations; */
};

static __const__ __u8 USB11_HUB_DEV_DESC[18] = {
	0x12,		/* __u8 bLength; */
	0x01,		/* __u8 bDescriptorType; Device */
	0x10, 0x01,	/* __le16 bcdUSB; v1.1 */

	0x09,		/* __u8 bDeviceClass; HUB_CLASSCODE */
	0x00,		/* __u8 bDeviceSubClass; */
	0x00,		/* __u8 bDeviceProtocol; [ low/full speeds only ] */
	0x08,		/* __u8 bMaxPacketSize0; 8 Bytes */

	0x00, 0x00, 	/* __le16 idVendor; */
	0x00, 0x00, 	/* __le16 idProduct; */
	0x01, 0x01,	/* __le16 bcdDevice */

	0x03,		/* __u8 iManufacturer; */
	0x02,		/* __u8 iProduct; */
	0x01,		/* __u8 iSerialNumber; */
	0x01		/* __u8 bNumConfigurations; */
};

static __const__ __u8 USB2_HUB_CFG_DESC[] = {

	/* one configuration */
	0x09,       /*  __u8  bLength; */
	0x02,       /*  __u8  bDescriptorType; Configuration */
	0x19, 0x00, /*  __le16 wTotalLength; */
	0x01,       /*  __u8  bNumInterfaces; (1) */
	0x01,       /*  __u8  bConfigurationValue; */
	0x00,       /*  __u8  iConfiguration; */
	0xc0,       /*  __u8  bmAttributes; 
				 Bit 7: must be set,
				     6: Self-powered,
				     5: Remote wakeup,
				     4..0: resvd */
	0x00,       /*  __u8  MaxPower; */
      
	/* USB 1.1:
	 * USB 2.0, single TT organization (mandatory):
	 *	one interface, protocol 0
	 *
	 * USB 2.0, multiple TT organization (optional):
	 *	two interfaces, protocols 1 (like single TT)
	 *	and 2 (multiple TT mode) ... config is
	 *	sometimes settable
	 *	NOT IMPLEMENTED
	 */

	/* one interface */
	0x09,       /*  __u8  if_bLength; */
	0x04,       /*  __u8  if_bDescriptorType; Interface */
	0x00,       /*  __u8  if_bInterfaceNumber; */
	0x00,       /*  __u8  if_bAlternateSetting; */
	0x01,       /*  __u8  if_bNumEndpoints; */
	0x09,       /*  __u8  if_bInterfaceClass; HUB_CLASSCODE */
	0x00,       /*  __u8  if_bInterfaceSubClass; */
	0x00,       /*  __u8  if_bInterfaceProtocol; [usb1.1 or single tt] */
	0x00,       /*  __u8  if_iInterface; */
     
	/* one endpoint (status change endpoint) */
	0x07,       /*  __u8  ep_bLength; */
	0x05,       /*  __u8  ep_bDescriptorType; Endpoint */
	0x81,       /*  __u8  ep_bEndpointAddress; IN Endpoint 1 */
 	0x03,       /*  __u8  ep_bmAttributes; Interrupt */
 	0x02, 0x00, /*  __le16 ep_wMaxPacketSize; 1 + (MAX_ROOT_PORTS / 8) */
	0x0c        /*  __u8  ep_bInterval; (256ms -- usb 2.0 spec) */
};

static __const__ __u8 USB11_HUB_CFG_DESC[] = {

	/* one configuration */
	0x09,       /*  __u8  bLength; */
	0x02,       /*  __u8  bDescriptorType; Configuration */
	0x19, 0x00, /*  __le16 wTotalLength; */
	0x01,       /*  __u8  bNumInterfaces; (1) */
	0x01,       /*  __u8  bConfigurationValue; */
	0x00,       /*  __u8  iConfiguration; */
	0xc0,       /*  __u8  bmAttributes; 
				 Bit 7: must be set,
				     6: Self-powered,
				     5: Remote wakeup,
				     4..0: resvd */
	0x00,       /*  __u8  MaxPower; */
      
	/* USB 1.1:
	 * USB 2.0, single TT organization (mandatory):
	 *	one interface, protocol 0
	 *
	 * USB 2.0, multiple TT organization (optional):
	 *	two interfaces, protocols 1 (like single TT)
	 *	and 2 (multiple TT mode) ... config is
	 *	sometimes settable
	 *	NOT IMPLEMENTED
	 */

	/* one interface */
	0x09,       /*  __u8  if_bLength; */
	0x04,       /*  __u8  if_bDescriptorType; Interface */
	0x00,       /*  __u8  if_bInterfaceNumber; */
	0x00,       /*  __u8  if_bAlternateSetting; */
	0x01,       /*  __u8  if_bNumEndpoints; */
	0x09,       /*  __u8  if_bInterfaceClass; HUB_CLASSCODE */
	0x00,       /*  __u8  if_bInterfaceSubClass; */
	0x00,       /*  __u8  if_bInterfaceProtocol; [usb1.1 or single tt] */
	0x00,       /*  __u8  if_iInterface; */
     
	/* one endpoint (status change endpoint) */
	0x07,       /*  __u8  ep_bLength; */
	0x05,       /*  __u8  ep_bDescriptorType; Endpoint */
	0x81,       /*  __u8  ep_bEndpointAddress; IN Endpoint 1 */
 	0x03,       /*  __u8  ep_bmAttributes; Interrupt */
 	0x02, 0x00, /*  __le16 ep_wMaxPacketSize; 1 + (MAX_ROOT_PORTS / 8) */
	0xff        /*  __u8  ep_bInterval; (255ms -- usb 2.0 spec) */
};

static __const__ __u8 USB_HUB_LANG_ID[4] = {
	0x04, 0x03, 0x09, 0x04
};

static void ENCODE_STRING(char *str, __const__ void **ptr, unsigned *len)
{
	static char buf[256];
	unsigned p = 2;
	while (*str && p < 256 - 2) {
		buf[p++] = *str++;
		buf[p++] = 0;
	}
	buf[0] = p;
	buf[1] = USB_DT_STRING;
}

void USB$HC_GENERIC_ROOT_CTRL(USB *usb, USB_CTRL_REQUEST *urq)
{
	urq->status = 0;
	switch (__16LE2CPU(urq->setup.request)) {
		case USB_CTRL_RQTYPE_DEVICE | USB_REQ_GET_STATUS: {
			if (__unlikely(urq->v.len != sizeof(__u16))) {
				urq->status = -EINVAL;
				break;
			}
			*(__u16 *)(unsigned long)urq->v.ptr = __16CPU2LE((usb->remote_wakeup << USB_DEVICE_FEAT_REMOTE_WAKEUP) | USB_DEVICE_STAT_SELF_POWERED);
			urq->status = 2;
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE_OUT | USB_REQ_CLEAR_FEATURE: {
			switch (urq->setup.w_value) {
				case USB_DEVICE_FEAT_REMOTE_WAKEUP: {
					usb->remote_wakeup = 0;
					break;
				}
				default: {
					goto unknown;
				}
			}
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE_OUT | USB_REQ_SET_FEATURE: {
			switch (urq->setup.w_value) {
				case USB_DEVICE_FEAT_REMOTE_WAKEUP: {
					usb->remote_wakeup = 1;
					break;
				}
				default: {
					goto unknown;
				}
			}
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE | USB_REQ_GET_CONFIGURATION: {
			if (__unlikely(urq->v.len != sizeof(__u8))) {
				urq->status = -EINVAL;
				break;
			}
			*(__u8 *)(unsigned long)urq->v.ptr = 1;
			urq->status = 1;
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE_OUT | USB_REQ_SET_CONFIGURATION: {
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE | USB_REQ_GET_DESCRIPTOR: {
			__const__ void *ptr;
			unsigned len;
			switch (__16LE2CPU(urq->setup.w_value) >> 8) {
				case USB_DT_DEVICE: {
					if (usb->op->flags & USB_HC_20) {
						ptr = USB2_HUB_DEV_DESC;
						len = sizeof(USB2_HUB_DEV_DESC);
					} else {
						ptr = USB11_HUB_DEV_DESC;
						len = sizeof(USB11_HUB_DEV_DESC);
					}
					break;
				}
				case USB_DT_CONFIG: {
					if (usb->op->flags & USB_HC_20) {
						ptr = USB2_HUB_CFG_DESC;
						len = sizeof(USB2_HUB_CFG_DESC);
					} else {
						ptr = USB11_HUB_CFG_DESC;
						len = sizeof(USB11_HUB_CFG_DESC);
					}
					break;
				}
				case USB_DT_STRING: {
					switch (__16LE2CPU(urq->setup.w_value) & 0xff) {
						case USB_DT_STRING_LANG_ID: {
							ptr = USB_HUB_LANG_ID;
							len = sizeof(USB_HUB_LANG_ID);
							break;
						}
						case USB_DT_STRING_SERIAL_NUMBER: {
							ENCODE_STRING(usb->dev_name, &ptr, &len);
							break;
						}
						case USB_DT_STRING_PRODUCT_DESCRIPTION: {
							ENCODE_STRING(usb->op->flags & USB_HC_20 ? "USB 2.0 HOST CONTROLLER" : "USB 1.1 HOST CONTROLLER", &ptr, &len);
							break;
						}
						case USB_DT_STRING_VENDOR_DESCRIPTION: {
							ENCODE_STRING("SPAD", &ptr, &len);
						}
						default: {
							goto unknown;
						}
					}
					break;
				}
				default: {
					goto unknown;
				}
			}
			if (__unlikely(len > urq->v.len)) len = urq->v.len;
			memcpy((void *)(unsigned long)urq->v.ptr, ptr, len);
			urq->status = len;
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE | USB_REQ_GET_INTERFACE: {
			if (__unlikely(urq->v.len != sizeof(__u8))) {
				urq->status = -EINVAL;
				break;
			}
			*(__u8 *)(unsigned long)urq->v.ptr = 0;
			urq->status = 1;
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE_OUT | USB_REQ_SET_INTERFACE: {
			break;
		}
		case USB_CTRL_RQTYPE_DEVICE_OUT | USB_REQ_SET_ADDRESS: {
			break;
		}
		case USB_CTRL_RQTYPE_ENDPOINT | USB_REQ_GET_STATUS: {
			if (__unlikely(urq->v.len != sizeof(__u16))) {
				urq->status = -EINVAL;
				break;
			}
			*(__u16 *)(unsigned long)urq->v.ptr = __16CPU2LE(0);
			urq->status = 2;
			break;
		}
		case USB_CTRL_RQTYPE_ENDPOINT_OUT | USB_REQ_CLEAR_FEATURE: {
			break;
		}
		case USB_CTRL_RQTYPE_ENDPOINT_OUT | USB_REQ_SET_FEATURE: {
			break;
		}
		case USBHUB_REQ_SET_HUB_FEATURE: {
			switch (__16LE2CPU(urq->setup.w_value)) {
				case USB_HUB_FEAT_C_OVER_CURRENT:
					break;
				case USB_HUB_FEAT_C_LOCAL_POWER:
					break;
				default:
					goto unknown;
			}
			break;
		}
		case USBHUB_REQ_CLEAR_HUB_FEATURE: {
			switch (__16LE2CPU(urq->setup.w_value)) {
				case USB_HUB_FEAT_C_OVER_CURRENT:
					break;
				case USB_HUB_FEAT_C_LOCAL_POWER:
					break;
				default:
					goto unknown;
			}
			break;
		}
		case USBHUB_REQ_SET_PORT_FEATURE: {
			switch (__16LE2CPU(urq->setup.w_value)) {
				case USB_PORT_FEAT_SUSPEND:
					break;
				case USB_PORT_FEAT_POWER:
					break;
				default:
					goto unknown;
			}
			break;
		}
		case USBHUB_REQ_CLEAR_PORT_FEATURE: {
			switch (__16LE2CPU(urq->setup.w_value)) {
				case USB_PORT_FEAT_SUSPEND:
					break;
				case USB_PORT_FEAT_C_SUSPEND:
					break;
				case USB_PORT_FEAT_POWER:
					break;
				case USB_PORT_FEAT_C_OVER_CURRENT:
					break;
				case USB_PORT_FEAT_C_RESET:
					break;
				default:
					goto unknown;
			}
			break;
		}
		default: {
			unknown:
			urq->status = -ENOOP;
			break;
		}
	}
	CALL_AST(urq);
}
