#ifndef __ASM_IO_H
#define __ASM_IO_H

#include <ARCH/IO.H>

static __finline__ __u8 inb(unsigned long port)
{
	return io_inb(port);
}

static __finline__ __u16 inw(unsigned long port)
{
	return io_inw(port);
}

static __finline__ __u32 inl(unsigned long port)
{
	return io_inl(port);
}

static __finline__ void outb(__u8 value, unsigned long port)
{
	io_outb(port, value);
}

static __finline__ void outw(__u16 value, unsigned long port)
{
	io_outw(port, value);
}

static __finline__ void outl(__u32 value, unsigned long port)
{
	io_outl(port, value);
}

static __finline__ __u8 inb_p(unsigned long port)
{
	return io_inb_p(port);
}

static __finline__ __u16 inw_p(unsigned long port)
{
	return io_inw_p(port);
}

static __finline__ __u32 inl_p(unsigned long port)
{
	return io_inl_p(port);
}

static __finline__ void outb_p(__u8 value, unsigned long port)
{
	io_outb_p(port, value);
}

static __finline__ void outw_p(__u16 value, unsigned long port)
{
	io_outw_p(port, value);
}

static __finline__ void outl_p(__u32 value, unsigned long port)
{
	io_outl_p(port, value);
}

static __finline__ void insb(unsigned long port, void *ptr, unsigned count)
{
	return io_insb(port, ptr, count);
}

static __finline__ void insw(unsigned long port, void *ptr, unsigned count)
{
	return io_insw(port, ptr, count);
}

static __finline__ void insl(unsigned long port, void *ptr, unsigned count)
{
	return io_insl(port, ptr, count);
}

static __finline__ void outsb(unsigned long port, void *ptr, unsigned count)
{
	return io_outsb(port, ptr, count);
}

static __finline__ void outsw(unsigned long port, void *ptr, unsigned count)
{
	return io_outsw(port, ptr, count);
}

static __finline__ void outsl(unsigned long port, void *ptr, unsigned count)
{
	return io_outsl(port, ptr, count);
}

#endif
