#ifdef __ASSERT_H
#undef assert
#else
#define __ASSERT_H
#endif

#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>

#ifndef NDEBUG

#if (!defined __GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ < (defined __cplusplus ? 6 : 4)))
#define assert(x)	(__likely((x) != 0) ? 0 : (KERNEL$SUICIDE("ASSERTION FAILED AT %s:%d", __FILE__, __LINE__), 0))
#else
#define assert(x)	(__likely((x) != 0) ? 0 : (KERNEL$SUICIDE("%s: ASSERTION FAILED AT %s:%d", __PRETTY_FUNCTION__, __FILE__, __LINE__), 0))
#endif

#else

#define assert(x)	((void)0)

#endif

