#ifndef __DIRENT_H
#define __DIRENT_H

#include <SYS/TYPES.H>

#define NAME_MAX	255

struct dirent {
	unsigned short d_reclen;
	unsigned char d_type;
	unsigned char d_namlen;
	char d_name[1];
};

#define	DT_UNKNOWN	 0
#define	DT_FIFO		 1
#define	DT_CHR		 2
#define	DT_DIR		 4
#define	DT_BLK		 6
#define	DT_REG		 8
#define	DT_LNK		10
#define	DT_SOCK		12
#define	DT_WHT		14

#define DTTOIF(dirtype)	((dirtype) << 12)

#define _DIRENT_ALIGN	4

typedef struct __dir DIR;

__BEGIN_DECLS

DIR *opendir(__const__ char *__name);
DIR *fdopendir(int __fd);
struct dirent *readdir(DIR *__d);
void rewinddir(DIR *__d);
int closedir(DIR *__d);
off_t telldir(DIR *__d);
void seekdir(DIR *__d, off_t __offset);
int dirfd(__const__ DIR *__d);

int scandir(__const__ char *__dir, struct dirent ***__namelist, int (*__select)(struct dirent *), int (*__compar)(__const__ void *, __const__ void *));
int alphasort(__const__ void *__a, __const__ void *__b);

__END_DECLS

#endif
