#ifndef __DLFCN_H
#define __DLFCN_H

#include <SYS/TYPES.H>

#define RTLD_LAZY		0x001
#define RTLD_NOW		0x002
#define RTLD_BINDING_MASK	0x003
#define RTLD_GLOBAL		0x100

typedef struct {
	__const__ char *dli_fname;
	void *dli_fbase;
	__const__ char *dli_sname;
	void *dli_saddr;
} Dl_info;

#define RTLD_DEFAULT		((void *)1)

__BEGIN_DECLS

void *dlopen(__const__ char *__filename, int __flag);
int dlclose(void *__handle);
__const__ char *dlerror(void);
void *dlsym(void *__handle, __const__ char *__symbol);
int dladdr(__const__ void *__addr, Dl_info *__info);

__END_DECLS

#endif
