#ifndef __ENDIAN_H
#define __ENDIAN_H

#include <ARCH/ENDIAN.H>
#include <SYS/TYPES.H>

#ifndef __static__
#define __static__ static
#endif

#define LITTLE_ENDIAN	1234
#define BIG_ENDIAN	4321
#define PDP_ENDIAN	3412

#ifdef __LITTLE_ENDIAN

#define __16CPU2LE(__x) (__x)
#define __16LE2CPU(__x) (__x)
#define __32CPU2LE(__x) (__x)
#define __32LE2CPU(__x) (__x)
#define __64CPU2LE(__x) (__x)
#define	__64LE2CPU(__x) (__x)

#define __16CPU2LE_CONST(__x) (__x)
#define __16LE2CPU_CONST(__x) (__x)
#define __32CPU2LE_CONST(__x) (__x)
#define __32LE2CPU_CONST(__x) (__x)
#define __64CPU2LE_CONST(__x) (__x)
#define	__64LE2CPU_CONST(__x) (__x)

#define BYTE_ORDER      LITTLE_ENDIAN

#else
#ifdef __BIG_ENDIAN

#define __16CPU2BE(__x) (__x)
#define __16BE2CPU(__x) (__x)
#define __32CPU2BE(__x) (__x)
#define __32BE2CPU(__x) (__x)
#define __64CPU2BE(__x) (__x)
#define	__64BE2CPU(__x) (__x)

#define __16CPU2BE_CONST(__x) (__x)
#define __16BE2CPU_CONST(__x) (__x)
#define __32CPU2BE_CONST(__x) (__x)
#define __32BE2CPU_CONST(__x) (__x)
#define __64CPU2BE_CONST(__x) (__x)
#define	__64BE2CPU_CONST(__x) (__x)

__BEGIN_DECLS

#ifdef __NO_INLINES
__u32 ntohl(__u32 __x);
#else
__static__ __finline__ __u32 ntohl(__u32 __x) { return __x; }
#endif

#ifdef __NO_INLINES
__u32 htonl(__u32 __x);
#else
__static__ __finline__ __u32 htonl(__u32 __x) { return __x; }
#endif

#ifdef __NO_INLINES
__u16 ntohs(__u16 __x);
#else
__static__ __finline__ __u16 ntohs(__u16 __x) { return __x; }
#endif

#ifdef __NO_INLINES
__u16 htons(__u16 __x);
#else
__static__ __finline__ __u16 htons(__u16 __x) { return __x; }
#endif

__END_DECLS

#define BYTE_ORDER      BIG_ENDIAN

#else

Unknown endian

#endif
#endif

#endif
