#ifndef __FCNTL_H
#define __FCNTL_H

#include <SYS/TYPES.H>

#define __O_FCNTL_GETFL_MASK	(_O_KRNL_READ | _O_KRNL_WRITE | O_APPEND | O_NONBLOCK | O_SYNC | O_ASYNC | O_DIRECT | O_NOFOLLOW | _O_PENDING_DELETE)
#define __O_FCNTL_GETFL_IOCTL	(O_APPEND | O_SYNC | O_DIRECT)
#define __O_FCNTL_SETFL_MASK	(O_APPEND | O_NONBLOCK | O_SYNC | O_ASYNC | O_DIRECT | _O_PENDING_DELETE)

#define O_ACCMODE	7
#define O_RDONLY	0
#define O_WRONLY	1
#define O_RDWR		2
#define _O_NOACCESS	3

#define _O_KRNL_READ	1	/* for kernel drivers ... */
#define _O_KRNL_WRITE	2	/* ... flags get incremented by 1 on open */
#define _O_KRNL_NOACCESS 4

#define _O_NOFASTSEEK	010

#define O_CREAT		0100
#define O_EXCL		0200
#define O_NOCTTY	0	/* unused */
#define O_TRUNC		01000
#define O_APPEND	02000
#define O_NONBLOCK	04000
#define O_NDELAY	O_NONBLOCK
#define FNDELAY		O_NONBLOCK

#define O_SYNC		010000	/* not implemented yet */
#define O_FSYNC		O_SYNC
#define O_ASYNC		020000	/* not implemented yet */
#define FASYNC		O_ASYNC
#define O_DIRECT	040000
#define O_LARGEFILE	0	/* unused */
#define _O_NOPOSIX	0100000
#define _O_RENAME	0200000
#define O_NOFOLLOW	0400000	/* unused */
#define _O_MKDIR	01000000	/* mkdir is actually O_CREAT | O_EXCL | _O_MKDIR | _O_CLOSE */
#define _O_MKDIR_QUOTA	O_APPEND
#define _O_NOOPEN_CALL	02000000
#define _O_DELETE_PROC	_O_NOOPEN_CALL
#define _O_DELETE	04000000	/* unlink is _O_DELETE | _O_CLOSE, rmdir is _O_DELETE | _O_CLOSE | _O_MKDIR */
#define _O_CLOSE	010000000
#define _O_SOCKET	020000000
#define _O_PIPE		040000000	/* warning: max is 1 << 23 --- it is this */

#define _O_NOOPEN	0100000000	/* this is not passed to kernel, so it can be more */
#define _O_NOMULTIOPEN	0200000000
#define _O_NOWAIT	0400000000
#define _O_LNWAIT	01000000000

#define _O_PENDING_DELETE 02000000000

#define _O_AUX1		010000000000
#define _O_KRNL_FORKED	020000000000U

#define FD_CLOEXEC	1		/* must be less than pointer size */

#define F_DUPFD		0
#define F_GETFD		1
#define F_SETFD		2
#define F_GETFL		3
#define F_SETFL		4
#define F_GETLK		5			/* !!! TODO: unimplemented */
#define F_SETLK		6
#define F_SETLKW	7

#define F_SETOWN	8		/* !!! TODO: unimplemented */
#define F_GETOWN	9
#define F_SETSIG	10
#define F_GETSIG	11

struct flock {
	off_t l_start;
	off_t l_len;
	pid_t l_pid;
	short l_type;
	short l_whence;
};

#define F_RDLCK		0
#define F_WRLCK		1
#define F_UNLCK		2

#define AT_FDCWD		-2
#define AT_EACCESS		0x0001
#define AT_SYMLINK_FOLLOW	0x0002
#define AT_SYMLINK_NOFOLLOW	O_NOFOLLOW
#define AT_REMOVEDIR		_O_MKDIR

__BEGIN_DECLS

int open(__const__ char *__path, int __oflags, ...);
int openat(int __dirfd, __const__ char *__path, int __oflags, ...);
int creat(__const__ char *__path, mode_t __mode);
int fcntl(int __h, int __opx, ...);

__END_DECLS

#endif
