#ifndef __MNTENT_H
#define __MNTENT_H

#include <PATHS.H>
#include <STDIO.H>
#include <SYS/TYPES.H>

#define MNTTAB		_PATH_MNTTAB

#define MOUNTED		_PATH_MOUNTED

#define MNTTYPE_IGNORE	"ignore"
#define MNTTYPE_NFS	"nfs"
#define MNTTYPE_SWAP	"swap"

#define MNTOPT_DEFAULTS	"defaults"
#define MNTOPT_RO	"ro"
#define MNTOPT_RW	"rw"
#define MNTOPT_SUID	"suid"
#define MNTOPT_NOSUID	"nosuid"
#define MNTOPT_NOAUTO	"noauto"

struct mntent {
	char *mnt_fsname;
	char *mnt_dir;
	char *mnt_type;
	char *mnt_opts;
	int mnt_freq;
	int mnt_passno;
};

__BEGIN_DECLS

FILE *setmntent(__const__ char *__file, __const__ char *__mode);
struct mntent *getmntent(FILE *__stream);
int addmntent(FILE *__stream, __const__ struct mntent *__mnt);
int endmntent(FILE *__stream);
char *hasmntopt(__const__ struct mntent *__mnt, __const__ char *__opt);

__END_DECLS

#endif

