#ifndef __NETINET_IN_H
#define __NETINET_IN_H

#include <SYS/TYPES.H>
#include <SYS/SOCKET.H>

#define IPPROTO_IP		0
#define IPPROTO_ICMP		1
#define IPPROTO_IGMP		2
#define IPPROTO_TCP		6
#define IPPROTO_UDP		17

typedef __u32 in_addr_t;
typedef __u16 in_port_t;

struct in_addr {
	in_addr_t s_addr;
};

#define IN_CLASSA(i)		(((in_addr_t)(i) & 0x80000000U) == 0)
#define IN_CLASSA_NET		0xff000000U
#define IN_CLASSA_NSHIFT	24
#define IN_CLASSA_HOST		0x00ffffffU
#define IN_CLASSA_MAX		0x80

#define IN_CLASSB(i)		(((in_addr_t)(i) & 0xc0000000U) == 0x80000000U)
#define IN_CLASSB_NET		0xffff0000U
#define IN_CLASSB_NSHIFT	16
#define IN_CLASSB_HOST		0x0000ffffU
#define IN_CLASSB_MAX		0x10000

#define IN_CLASSC(i)		(((in_addr_t)(i) & 0xe0000000U) == 0xc0000000U)
#define IN_CLASSC_NET		0xffffff00U
#define IN_CLASSC_NSHIFT	8
#define IN_CLASSC_HOST		0x000000ffU

#define IN_CLASSD(i)		(((in_addr_t)(i) & 0xf0000000U) == 0xe0000000U)
#define IN_CLASSD_NET		0xf0000000U
#define IN_CLASSD_NSHIFT	28
#define IN_CLASSD_HOST		0x0fffffffU

#define IN_MULTICAST(i)		IN_CLASSD(i)
#define IN_EXPERIMENTAL(i)	(((in_addr_t)(i) & 0xe0000000U) == 0xe0000000U)
/* IN_EXPERIMENTAL definition differs:
Irix, BSD: (((in_addr_t)(i) & 0xf0000000U) == 0xf0000000U)
Linux, Solaris: (((in_addr_t)(i) & 0xe0000000U) == 0xe0000000U)
*/
#define IN_BSDCLASS(i)		(((in_addr_t)(i) & 0xf0000000U) == 0xf0000000U)

#define INADDR_ANY		((in_addr_t)0x00000000U)
#define INADDR_LOOPBACK		((in_addr_t)0x7f000001U)
#define INADDR_BROADCAST	((in_addr_t)0xffffffffU)
#define INADDR_NONE		((in_addr_t)0xffffffffU)

#define INADDR_UNSPEC_GROUP	((in_addr_t)0xe0000000U)
#define INADDR_ALLHOSTS_GROUP	((in_addr_t)0xe0000001U)
#define INADDR_ALLRTRS_GROUP	((in_addr_t)0xe0000002U)
#define INADDR_MAX_LOCAL_GROUP	((in_addr_t)0xe00000ffU)

#define IN_LOOPBACKNET		0x7f

/* warning: duplicated in LIB/LIBC/NET/GETNAMEINFO.C: struct sockinet */
struct sockaddr_in {
	unsigned sin_len;
	sa_family_t sin_family;
	in_port_t sin_port;
	struct in_addr sin_addr;
};

#define sin_zero sin_len

#define INET_ADDRSTRLEN		sizeof(struct sockaddr_in)

#define IPPORT_ANY		0
#define IPPORT_ECHO		7
#define IPPORT_SYSTAT		11
#define IPPORT_DAYTIME		13
#define IPPORT_NETSTAT		15
#define IPPORT_FTP		21
#define IPPORT_SSH		22
#define IPPORT_TELNET		23
#define IPPORT_SMTP		25
#define IPPORT_TIMESERVER	37
#define IPPORT_NAMESERVER	42
#define IPPORT_WHOIS		43
#define IPPORT_MTP		57
#define IPPORT_TFTP		69
#define IPPORT_RJE		77
#define IPPORT_FINGER		79
#define IPPORT_HTTP		80
#define IPPORT_TTYLINK		87
#define IPPORT_SUPDUP		95
#define IPPORT_EXECSERVER	512
#define IPPORT_BIFFUDP		512
#define IPPORT_LOGINSERVER	513
#define IPPORT_WHOSERVER	513
#define IPPORT_CMDSERVER	514
#define IPPORT_EFSSERVER	520
#define IPPORT_ROUTESERVER	520

#define IPPORT_RESERVEDSTART	600
#define IPPORT_RESERVED		1024
#define IPPORT_USERRESERVED	5000
#define IPPORT_HIFIRSTAUTO	49152
#define IPPORT_HILASTAUTO	65535
#define IPPORT_MAX		65536

struct ip_mreq {
	struct in_addr imr_multiaddr;
	struct in_addr imr_interface;
};

#define SOL_IP			0
#define SOL_TCP			IPPROTO_TCP
#define SOL_UDP			IPPROTO_UDP

#define IP_TOS			1
#define IP_MULTICAST_TTL	2
#define IP_ADD_MEMBERSHIP	3
#define IP_DROP_MEMBERSHIP	4
#define IP_MULTICAST_IF		5

#define TCP_NODELAY		1
#define TCP_CORK		2
#define TCP_NOPUSH		TCP_CORK

#endif
