#ifndef __SPAD_AC_H
#define __SPAD_AC_H

#include <ARCH/AC.H>
#include <ARCH/BITOPS.H>
#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>

__BEGIN_DECLS

void KERNEL$CIO(IORQ *RQ);

extern IO_STUB KERNEL$SUCCESS;

__END_DECLS

#define GET_STRUCT(PTR, TYPE, MEMBER) ((TYPE*)((char*)(PTR)-(unsigned long)(&((TYPE*)0)->MEMBER)))

#define IO_ENABLE_CANCEL(spl, io, stub)					\
do {									\
	if (__DEBUG >= 2 && __unlikely(KERNEL$SPL != SPL_X(spl)))	\
		KERNEL$SUICIDE("IO_ENABLE_CANCEL AT SPL %08X, EXPECTED %08X", KERNEL$SPL, SPL_X(spl));							\
	RAISE_SPL(SPL_TOP);						\
	(io)->tmp1 = (unsigned long)stub;				\
	if (__unlikely((io)->status == RQS_WANTCANCEL)) {		\
		(io)->status = RQS_CANCELING;				\
		LOWER_SPL(spl);						\
		CALL_IORQ_LSTAT_EXPR(io, stub);				\
	} else {							\
		(io)->status = RQS_CANCELABLE;				\
		LOWER_SPL(spl);						\
	}								\
} while (0)

#define IO_DISABLE_CANCEL(spl, io, cancel_in_progress)			\
{									\
	if (__DEBUG >= 2 && __unlikely(KERNEL$SPL != SPL_X(spl)))	\
		KERNEL$SUICIDE("IO_DISABLE_CANCEL AT SPL %08X, EXPECTED %08X", KERNEL$SPL, SPL_X(spl));							\
	RAISE_SPL(SPL_TOP);						\
	if (__unlikely((io)->status == RQS_CANCELING)) {		\
		LOWER_SPL(spl);						\
		cancel_in_progress;					\
	}								\
	(io)->status = RQS_PROCESSING;					\
	LOWER_SPL(spl);							\
}

#define IO_DISABLE_CHAIN_CANCEL(spl, io)				\
do {									\
	if (__DEBUG >= 2 && __unlikely(KERNEL$SPL != SPL_X(spl)))	\
		KERNEL$SUICIDE("IO_DISABLE_CHAIN_CANCEL AT SPL %08X, EXPECTED %08X", KERNEL$SPL, SPL_X(spl));						\
	__CMPXCHGL(&(io)->status, RQS_CHAINCANCELABLE, RQS_PROCESSING);	\
} while (0)

#define IO_ENABLE_KERNEL_CANCEL(io, cancel_in_progress)			\
{									\
	int __st;							\
	again:								\
	if (__likely(((__st = (io)->status) & RQS_ACTION_MASK) == RQS_PROCESSING)) { 									\
		if (__unlikely(__CMPXCHGL(&(io)->status, __st, RQS_KERNELCANCELABLE) != 0)) goto again; 						\
	} else {							\
		__ORL(&(io)->status, 0); /* probe write access */	\
		if (__unlikely(__st == RQS_WANTCANCEL)) {		\
			(io)->status = -EINTR;				\
			CALL_AST(io);					\
			cancel_in_progress;				\
		}							\
	}								\
}

#endif
