#ifndef __SPAD_ALLOC_H
#define __SPAD_ALLOC_H

#include <SYS/TYPES.H>
#include <SPAD/AC.H>
#include <SPAD/WQ.H>
#include <SPAD/VMDEF.H>

__BEGIN_DECLS

typedef struct {
	IORQ_HEAD;
	void *ptr;
	int nclusters;
	int flags;
	int align;	/* requested alignment minus 1.
			   0 -- no alignment needed,
			   65535 -- align on 2**16 for dma0-dma3,
			   131071 -- align on 2**17 for dma5-dma7, etc. */
} CONTIG_AREA_REQUEST;

#define CARF_CODE	1
#define CARF_DATA	2
#define CARF_ISADMA	4
#define CARF_PHYSCONTIG	8
#define CARF_PCIDMA	16

extern IO_STUB KERNEL$VM_GRAB_CONTIG_AREA;
void KERNEL$VM_RELEASE_CONTIG_AREA(void *vmap, int npages);



typedef struct {
	IORQ_HEAD;
	void *ptr;
	size_t size;
} MALLOC_REQUEST;

extern IO_STUB KERNEL$UNIVERSAL_MALLOC;
void KERNEL$UNIVERSAL_FREE(void *p);

/* when KERNEL$OOM != 0, do not sleep at KERNEL$FREEMEM_WAIT, and return
   allocation error directly ... you won't probably get any memory at all,
   because kernel is out of memory ...
   when KERNEL$OOM != 0, you may sleep at KERNEL$FREEMEM_WAIT only if you
   cannot (because of some critical reason, I can't think of any now)
   return allocation error. If your memory request has critical priority, you
   can sleep on KERNEL$OOM and expect that *MAYBE* someone will free some memory
   after some time.
   DO NOT sleep on KERNEL$FREEMEM_WAIT if your driver may be needed to free
   some memory (i.e. block device, filesystem, net device, net protocol that
   filesystems may run on)
*/

extern WQ KERNEL$FREEMEM_WAIT;
int KERNEL$OOM(int type);
int KERNEL$OOM_ERR(size_t size);

extern IO_STUB KERNEL$WAIT_ON_FREEMEM;

void KERNEL$MEMWAIT(IORQ *rq, IO_STUB *fn, size_t sz);
int KERNEL$MEMWAIT_SYNC(size_t sz);

__END_DECLS

#endif
