#ifndef __SPAD_BIO_H
#define __SPAD_BIO_H

#include <SYS/TYPES.H>
#include <SPAD/AC.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/PROC.H>
#include <ARCH/TIME.H>

typedef struct __biodesc BIODESC;

#define BIO_SECTOR_SIZE_BITS	9	/* do not change -- hardwired in device drivers, vfs and filesystems */
#define BIO_SECTOR_SIZE		(1 << BIO_SECTOR_SIZE_BITS)

#define BIO_FLAG_MASK		0xffff	/* reserved 16 flags, if others are set
					   kernel will panic in order to not
					   damage data on memory corruption */

#define BIO_READ		0
#define BIO_WRITE		1	/* must be 1 */
#define BIO_FLUSH		2	/* sec must be 0, nsec must be 1 */

/* at end, these fields may be trashed: sec, nsec, desc, desc->v.ptr, desc->v.len, desc->next */

#define __BIORQ_ENTRIES							\
	int h;								\
	HANDLE *handle;							\
	BIODESC *desc;							\
	__sec_t sec;							\
	int nsec;							\
	int flags;							\
	__sec_t fault_sec;	/* -1 --- unknown */			\
	__sec_t partition;	/* used internally */			\
	u_jiffies_lo_t enq_time;					\
	void *p;		/* unused; available for the driver */	\

typedef struct {
	IORQ_HEAD;
	AIORQ a;
} _ABIORQ;

typedef struct {
	IORQ_HEAD;
	IOCTLRQ i;
} _IBIORQ;

struct __biorq_for_size {
	IORQ_HEAD;
	__BIORQ_ENTRIES
};

#define _ms (sizeof(_ABIORQ) > sizeof(_IBIORQ) ? sizeof(_ABIORQ) : sizeof(_IBIORQ))

typedef struct {
	IORQ_HEAD;
	__BIORQ_ENTRIES
	long _aiorq_pad[sizeof(struct __biorq_for_size) > _ms ? 0 : ((_ms - sizeof(struct __biorq_for_size)) + sizeof(long) - 1) / sizeof(long)];
	PROC *proc;	/* proc must survive conversion to AIORQ */	\
} BIORQ;

/**** caller must make sure that v.ptr and v.len are aligned to BIO_SECTOR_SIZE.
 **** If they aren't, the driver might CRASH !!!! */
struct __biodesc {
	VDESC v;
	BIODESC *next;
};

#endif
