#ifndef __SPAD_BIO_KRNL_H
#define __SPAD_BIO_KRNL_H

#include <SPAD/BIO.H>
#include <SPAD/LIST.H>
#include <SYS/TYPES.H>
#include <SPAD/AC.H>
#include <SPAD/SCHED.H>
#include <SPAD/DL.H>
#include <ERRNO.H>

__BEGIN_DECLS

typedef struct __bioqueue BIOQUEUE;

int BIOQUE$ALLOC_QUEUE(BIOQUEUE **qq);
void BIOQUE$FREE_QUEUE(BIOQUEUE *q);
void BIOQUE$ACCOUNT_IOSCHED(PROC *p, BIOQUEUE *q, sched_unsigned start, sched_unsigned now);
void BIOQUE$ENQUEUE_REQUEST(BIOQUEUE *q, BIORQ *rq);
int BIOQUE$QUEUE_EMPTY(BIOQUEUE *q);
BIORQ *BIOQUE$DEQUEUE(BIOQUEUE *q);
void BIOQUE$SET_HEAD(BIOQUEUE *b, __usec_t sec);
void BIOQUE$ACK_DEQUEUE(BIOQUEUE *q);
void BIOQUE$REQUEUE_DEQUEUED_REQUEST(BIOQUEUE *b, BIORQ *rq);
BIORQ *BIOQUE$DEQUEUE_FLUSHES(BIOQUEUE *q);
BIORQ *BIOQUE$PROBE_QUEUE(BIOQUEUE *q);
#define BIO_COMPARE_UNSPECIFIED		((BIORQ *)1)
int BIOQUE$IOSCHED(BIOQUEUE *b);
long BIOQUE$COMPARE_REQUESTS(BIORQ *rq1, int s1, BIORQ *rq2, int s2);
void BIOQUE$CHECK_QUEUE(__const__ char *msg, BIOQUEUE *q, BIORQ *rq);

typedef struct __biopartition BIOPARTITION;
typedef struct __partitions PARTITIONS;

typedef struct {
	__sec_t start;
	__sec_t len;
	void *dev;
	PARTITIONS *p;
	XLIST_HEAD list;
} PARTITION;

/* ioctl returns:
	0 --- ok, caller should post AST
	> 0 --- caller should exit, third arg (IORQ) queued 
	< 0 --- caller should use generic implementation, request not modified
*/
int BIO$ALLOC_PARTITIONS(PARTITIONS **pp, void *dev, __sec_t dev_blocx, int (*ioctl)(IOCTLRQ *, PARTITION *, IORQ *), char *dev_name);
void BIO$SET_PARTITIONS_SIZE(PARTITIONS *p, __sec_t dev_blocx);
void BIO$FREE_PARTITIONS(PARTITIONS *p);
void BIO$ROOT_PARTITION(HANDLE *h, PARTITIONS *p);
void *BIO$LOOKUP_PARTITION(HANDLE *h, char *str, int open_flags);
void *BIO$INSTANTIATE_PARTITION(HANDLE *h, IORQ *rq, int open_flags);
void BIO$DETACH(HANDLE *h);

#if __DEBUG >= 1
#define BIO_ASSERT_FAULT_SEC						\
do {									\
	if (__unlikely(RQ->fault_sec != -1))				\
		KERNEL$SUICIDE("KERNEL$BIO_EMU: fault_sec NOT SET: %"__sec_t_format"X, AST %s", RQ->fault_sec, KERNEL$DL_GET_SYMBOL_NAME(RQ->fn, (unsigned long *)(void *)&KERNEL$LIST_END, 0));					\
} while (0)
#else
#define BIO_ASSERT_FAULT_SEC	do { } while (0)
#endif

	/* !!! FIXME: redo this when new ata will be finished */
#define BIO_TRANSLATE_PARTITION						\
do {									\
	BIO_ASSERT_FAULT_SEC;						\
	RQ->partition = ((PARTITION *)h->fnode)->start;			\
	RQ->sec += RQ->partition;					\
	if (__unlikely((__usec_t)RQ->sec < RQ->partition)) goto out;	\
	if (__unlikely((__usec_t)RQ->sec + (unsigned)RQ->nsec > ((PARTITION *)h->fnode)->start + ((PARTITION *)h->fnode)->len) && !(RQ->flags & BIO_FLUSH)) goto out;									\
	if (__unlikely((__usec_t)RQ->sec + (unsigned)RQ->nsec <= RQ->sec)) goto out;									\
} while (0)

void BIO$FAULT(BIORQ *rq, __sec_t sec);
void BIO$ERROR(BIORQ *rq, __sec_t sec);

extern IO_STUB BIO$READ;
extern IO_STUB BIO$WRITE;
extern IO_STUB BIO$AREAD;
extern IO_STUB BIO$AWRITE;
extern IO_STUB BIO$IOCTL;

void BIO$CHECK_REQUEST(__const__ char *msg, BIORQ *rq);

__END_DECLS

#endif
