#ifndef __SPAD_DEV_H
#define __SPAD_DEV_H

#include <SPAD/AC.H>
#include <SPAD/LIST.H>
#include <SYS/TYPES.H>
#include <FCNTL.H>
#include <SPAD/ALLOC.H>
#include <SPAD/LIBC.H>

#define POSIX_RESERVED_HANDLES			0x10	/* must be power of 2 */
#define SWAPPER_HANDLE				0x100
#define BLOCK_HANDLE				0x100000

__BEGIN_DECLS

typedef struct __handle HANDLE;
typedef struct __cwd CWD;
typedef struct __fblob FBLOB;

extern HANDLE KERNEL$VIRTUAL;
extern HANDLE KERNEL$PHYSICAL;

typedef struct {
	__v_off ptr;
	unsigned long len;
	HANDLE *vspace;
} VDESC;

typedef struct {
	IORQ_HEAD;
	int handle;		/* used internally, must be at this position! */
	int flags;
	__const__ char *path;
	CWD *cwd;
	int rename_handle;
	AST_STUB *real_ast;	/* used internally */
} OPENRQ;

typedef struct {
	IORQ_HEAD;
	int h;			/* must be at this position! */
	AST_STUB *real_ast;	/* used internally */
} CLOSERQ;

typedef struct {
	IORQ_HEAD;
	int h;		/* h must be first after IORQ_HEAD in SIORQ, AIORQ, IOCTLRQ, OPENRQ, CLOSERQ */
	VDESC v;	/* v must be first after h in SIORQ, AIORQ, IOCTLRQ */
	long progress;	/* must be last field modified by kernel, otherwise fix UASM.S */
	HANDLE *handle;
} SIORQ;

typedef struct {
	IORQ_HEAD;
	int h;			/* must be at this position! */
	VDESC v;
	_u_off_t pos;
	long progress;	/* must be last field modified by kernel, otherwise fix UASM.S */
	HANDLE *handle;
} AIORQ;

typedef struct {
	IORQ_HEAD;
	int h			/* must be at this position! */;
	VDESC v;
	unsigned ioctl;
	unsigned long param;
	HANDLE *handle;
} IOCTLRQ;

extern IO_STUB KERNEL$OPEN;
extern IO_STUB KERNEL$CLOSE;
extern IO_STUB KERNEL$READ;
extern IO_STUB KERNEL$WRITE;
extern IO_STUB KERNEL$AREAD;
extern IO_STUB KERNEL$AWRITE;
extern IO_STUB KERNEL$IOCTL;
extern IO_STUB KERNEL$BIO;
extern IO_STUB KERNEL$PKTIO;

void KERNEL$FAST_CLOSE(int h);
HANDLE *KERNEL$GET_HANDLE(int h);
char *KERNEL$HANDLE_PATH(int h);
int KERNEL$HANDLE_FLAGS(int h);

typedef struct {
	IORQ_HEAD;
	int unload;
	__const__ char *name;
	char **argv;
	CWD *cwd;
	int std_in;
	int std_out;
	int std_err;
	char error[__MAX_STR_LEN];
} DCTLRQ;

extern IO_STUB KERNEL$DCTL;

typedef struct {
	IORQ_HEAD;
	int h;
	char *option;
	char *value;

	IOCTLRQ ioctlrq;
} CHHRQ;

extern IO_STUB KERNEL$CHANGE_HANDLE;

#define BLOB_HEAD		\
	size_t size;		\
	__u32 type;		\
	unsigned l_refcount

struct __fblob {
	BLOB_HEAD;
};

typedef struct {
	IORQ_HEAD;
	int h;
	FBLOB *blob;
} HBLOBRQ;

extern IO_STUB KERNEL$SET_HANDLE_BLOB;
void KERNEL$UNREF_BLOB(FBLOB *b);

#define LNTE_PUBLIC		(__INT_SGN_BIT >> 1)
#define LNTE_BLOCK_IF_NOT_FOUND	(__INT_SGN_BIT >> 2)
#define LNTE_FILE_SHARE		(__INT_SGN_BIT >> 3)
#define LNTE_DONT_WAKE_ALL	(__INT_SGN_BIT >> 4)	/* usable in KERNEL$REGISTER_DEVICE */
#define LNTE_DEVICE		(__INT_SGN_BIT >> 4)	/* used internally, do not set */
#define LNTE_HANDLE_MASK	((__INT_SGN_BIT >> 4) - 1)

#define MAX_HANDLE		(LNTE_HANDLE_MASK + 1)

#define LNTE_PARENT		-1	/* returned by KERNEL$LIST_LOGICALS */

typedef struct {
	IORQ_HEAD;
	__const__ char *name;
	__const__ char *alias;
	int flags;	/* LNTE_PUBLIC | LNTE_BLOCK_IF_NOT_FOUND | LNTE_FILE_SHARE */
	int flags_chg_mask;	/* used in KERNEL$SET_LOGICAL */
	char *chh_option;
	char *chh_value;
	FBLOB *blob;
	CWD *cwd;
	union {
		OPENRQ open;
		MALLOC_REQUEST mrq;
		CHHRQ chh;
		HBLOBRQ brq;
	} u;
} LOGICAL_REQUEST;

/* user must fill in name, alias, flags and cwd */
extern IO_STUB KERNEL$CREATE_LOGICAL;
extern IO_STUB KERNEL$SET_LOGICAL;

	/* returns: 0 - success, < 0 - error */
int KERNEL$DELETE_LOGICAL(char *name, int flags);

#define DELETE_LOGICAL_BLOCK		1
#define DELETE_LOGICAL_UNUSED		2	/* only in KERNEL$UNREGISTER_DEVICE */
#define DELETE_LOGICAL_DONT_WAKE_ALL	4

typedef struct {
	LIST_ENTRY list;
	char *driver_name;
	int flags;
	char name[1];
} LOGICAL_LIST_ENTRY;

typedef struct {
	IORQ_HEAD;
	char *prefix;
	size_t n_entries;
	LOGICAL_LIST_ENTRY **entries;
	XLIST_HEAD freelist;
} LOGICAL_LIST_REQUEST;

extern IO_STUB KERNEL$LIST_LOGICALS;

void KERNEL$FREE_LOGICAL_LIST(LOGICAL_LIST_REQUEST *r);

extern WQ KERNEL$LOGICAL_WAIT;

extern unsigned char KERNEL$LOCKUP_LEVEL;
extern WQ KERNEL$LOCKUP_EVENTS;

#define LOCKUP_LEVEL_NONE		0
#define LOCKUP_LEVEL_ONE_PASS		1
#define LOCKUP_LEVEL_ALL_IORQS		0x80
#define LOCKUP_LEVEL_KERNEL_IORQS	0x81

#define KERNEL_NO_RESTART_PRIORITY	8

#define TEST_LOCKUP_SYNC						\
do {									\
	if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) WQ_WAIT_SYNC(&KERNEL$LOCKUP_EVENTS);						\
} while (0)

__END_DECLS

#endif
