#ifndef __SPAD_DIR_KRNL_H
#define __SPAD_DIR_KRNL_H

#include <SPAD/IOCTL.H>
#include <DIRENT.H>
#include <SYS/TYPES.H>

#define COOKIE_SIZE_FLAG_INTERNAL	0x8000
#define COOKIE_SIZE_MASK		0x7fff

struct readdir_buffer {
	struct readdir_buffer *next;	/* unused by kernel, for userspace linking */
	char page;			/* unused by kernel */
	char end;	/* set to 1 by kernel on the end of directory */
	unsigned short int cookie_size;
	unsigned dirent_start;	/* offset from the start to the first struct dirent */
	unsigned long total_size;
					/* unsigned long is for proper align of a cookie */
	unsigned char cookie[1];
};

#define DIRENT_START_FROM_COOKIE_SIZE(c)	(((int)(unsigned long)&((struct readdir_buffer *)NULL)->cookie + (c) + _DIRENT_ALIGN - 1) & ~(unsigned long)(_DIRENT_ALIGN - 1))

/* & (__PAGE_CLUSTER_SIZE - 1) in next macros is there to prevent userspace from wrapping the pointer by calling with bogus values */

#define DIR_START(rb)	((struct dirent *)(((unsigned long)(rb) + ((rb)->dirent_start & __PAGE_CLUSTER_SIZE_MINUS_1) + _DIRENT_ALIGN - 1) & ~(unsigned long)(_DIRENT_ALIGN - 1)))

#define DIR_END(rb)	((struct dirent *)(((unsigned long)(rb) + ((rb)->total_size & (2 * __PAGE_CLUSTER_SIZE - 1)) + _DIRENT_ALIGN - 1) & ~(unsigned long)(_DIRENT_ALIGN - 1)))

#define DIR_NEXT(d)	((struct dirent *)(((unsigned long)(d) + ((d)->d_reclen & __PAGE_CLUSTER_SIZE_MINUS_1) + _DIRENT_ALIGN - 1) & ~(unsigned long)(_DIRENT_ALIGN - 1)))

#define DIRENT_LENGTH(l)	((sizeof(struct dirent) + (l) + 1 + _DIRENT_ALIGN - 1) & ~(unsigned long)(_DIRENT_ALIGN - 1))

#endif
