#ifndef __SPAD_DL_H
#define __SPAD_DL_H

#include <SPAD/LIBC.H>
#include <SPAD/AC.H>
#include <SPAD/ALLOC.H>
#include <SPAD/DEV.H>
#include <SPAD/THREAD.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef struct {
	IORQ_HEAD;
	char *error;
} DLINITRQ;

typedef struct {
	IORQ_HEAD;
	int type;
	void *ld_handle;
	char filename[__MAX_STR_LEN];
	char modname[__MAX_STR_LEN];
	char error[__MAX_STR_LEN];
} DLRQ;

#define DLT_EXPORT	1

extern IO_STUB KERNEL$DL_LOAD_MODULE;
extern IO_STUB KERNEL$DL_UNLOAD_MODULE;

void KERNEL$DL_CALL_DTORS(void);

int KERNEL$DL_GET_SYMBOL(DLRQ *d, char *name, unsigned long *val);
__const__ char *KERNEL$DL_GET_SYMBOL_NAME(__const__ void *sym, unsigned long *offset, int codeonly);

typedef struct {
	IORQ_HEAD;
	DLRQ *handle;
	void *caller;
	char modname[__MAX_STR_LEN];
	char error[__MAX_STR_LEN];
} DLLZRQ;

extern IO_STUB KERNEL$DL_LOAD_LAZY;

typedef struct {
	char **argv;
	char **env;
} START_ARG;

typedef struct {
	IORQ_HEAD;
	DLRQ *handle;
	char filename[__MAX_STR_LEN];
	char error[__MAX_STR_LEN];
	char **argv;
	CWD *cwd;
	int std_in;
	int std_out;
	int std_err;
	int device;	/* when != 0, load device, not image */
	THREAD_RQ t;
	START_ARG a;
} DLIMGRQ;

void __DL_INIT(void *code, void *code_top, void *data, void *data_top);
void *__DL_GET_KERNEL_HANDLE(void);
void __DL_USER_INIT(int mprot);
long __DL_USER_LOAD_EXE(__const__ char *filename, START_ARG *start, void **handle);

extern IO_STUB KERNEL$DL_LOAD_IMAGE;

__END_DECLS

#endif
