#ifndef __SPAD_HASH_H
#define __SPAD_HASH_H

#include <SYS/TYPES.H>

/* note: evaluate `ch' only once !! */
#define quickcasehashchar(ch, hash)		\
do {						\
	(hash) += (ch) & 0xdf;			\
	(hash) = ((hash) << 4) - (hash);	\
} while (0)

#define quickcasehash(str, contcond, hash)				\
do {									\
	while (__likely((contcond))) {					\
		quickcasehashchar(*(str)++, hash);			\
	}								\
} while (0)

#endif
