#ifndef __SPAD_LIBPROC_H
#define __SPAD_LIBPROC_H

#include <SPAD/AC.H>
#include <SPAD/DEV.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

#define LN_NONE		0
#define LN_PUBLIC	1
#define LN_ALL		2

#define MAX_PROC_DEPTH  64

#define NO_SESSION		((void *)1)

typedef struct {
	IORQ_HEAD;
	char *mapextra;
	int default_lnm;
	char **params;
	char **env;		/* unused for remap */
	CWD *cwd;

	void *session;		/* used for remap */
	char jobname[9];	/* used for remap */
	int info;

	void *session_change;

	void *pcb;		/* used internally */
} PROC_SPAWN_RQ;

#define PROC_INFO_AUTO_EXIT	0x40000000

extern IO_STUB KERNEL$PROC_SPAWN;
extern IO_STUB KERNEL$PROC_REMAP;

int KERNEL$PROC_GET_FLAGS(char *proc, void *session, void **session_result);
void KERNEL$PROC_GET_JOB_NAME(char from[9]);

typedef struct {
	IORQ_HEAD;
	char jobname[9];
	int op;
	char *msg;	/* must be always initialized --- for anything except PROC_CTRL_WAIT and PROC_CTRL_NOWAIT initialize to (char *)&KERNEL$LIST_END */
	void *session;
} PROC_CTRL_RQ;

extern IO_STUB KERNEL$PROC_CTRL;

#define PROC_CTRL_STOP		1
#define PROC_CTRL_RESUME	2
#define PROC_CTRL_KILL		3
#define PROC_CTRL_ZAP		4
#define PROC_CTRL_WAIT		5
#define PROC_CTRL_NOWAIT	6

#define PROC_RUNNING		(-0x100000)

__END_DECLS

#endif
