#ifndef __SPAD_LINK_H
#define __SPAD_LINK_H

#include <SYS/TYPES.H>
#include <ARCH/LINK.H>

#define LINK_ALIGN	sizeof(__f_off)

#define LNK_ID		0x44415053
#define LNK_VER		1

#define LINK_MAX_RCOUNT		3

#define LINK_DYNAMIC_SYMBOL_NAME_LEN	256	/* including 0 byte */

#define REL_SPECIAL			0xc0
#define REL_SPECIAL_LONG1		0x20
#define REL_SPECIAL_LONG1_VAL		0x1f
#define REL_SPECIAL_RLE			0x10
#define REL_SPECIAL_RLE_REPEAT_MINUS_3	0x0f
#define REL_SPECIAL_LONG2		0x08
#define REL_SPECIAL_LONG2_BYTES_MINUS_1	0x07
#define REL_SPECIAL_TYPE_SECTION	0x00
#define REL_SPECIAL_TYPE_MASK		0x07
#define REL_SPECIAL_TYPE_END		0x00
#define REL_SPECIAL_TYPE_ADD		0x01
#define REL_SPECIAL_TYPE_SUB		0x02
#define REL_SPECIAL_TYPE_INVALID	0x03

#define REL_DEFAULT_TYPE		REL_SPECIAL_TYPE_ADD
#define REL_DEFAULT_SECTION		1

struct relocs {
	__f_off last_val;
	__f_off rel;		/* ptr to compressed stream of relocs */
};

struct section {
	__f_off ptr;
	__f_off name;
	__f_off offset;
	__f_off len;
	struct relocs relocs;
};

#define LINK_HASH_LENGTH	64

struct link_header {
	unsigned lnk_id;
	unsigned lnk_ver;
	unsigned mach_id;
	unsigned mach_flags;

	__u8 hash_stir[48];
	__u8 hash[LINK_HASH_LENGTH];

		/* position hardcoded in LOADER.S and BOOTASM.S */
	unsigned char startup_code[LINK_STARTUP_CODE_SIZE];

	unsigned flags;

	unsigned n_sections;
	__f_off sections;	/* ptr to struct section */

	__f_off lib_name;	/* ptr to char */

	__f_off syms;		/* ptr to struct sym */
	unsigned n_exported_syms;
	unsigned n_special_syms;
	unsigned n_syms;

	unsigned n_libs;
	__f_off libs;		/* ptr to struct library */

	__f_off compression_offset;
	__f_off compressed_file_size;
};

#define LINK_SHARED		0x00000001
#define LINK_STRIPPED		0x00000002
#define LINK_HASH_MASK		0x00ff0000
#define LINK_HASH_NONE		0x00000000
#define LINK_HASH_MD5		0x00010000
#define LINK_HASH_SHA1		0x00020000
#define LINK_HASH_RIPEMD160	0x00030000
#define LINK_HASH_SHA256	0x00040000
#define LINK_COMPRESSION_MASK	0xff000000
#define LINK_COMPRESSION_ZLIB	0x01000000

#define LINK_COMPRESS_NONE	0

#define SECTION_HEAD		0
#define SECTION_TEXT		1
#define SECTION_RODATA		2
#define SECTION_DATA		3
#define SECTION_BSS		4

struct library {
	__f_off lib_name;	/* ptr to char */
	__f_off syms;		/* ptr to struct lib_sym */
	unsigned n_syms;
	unsigned flags;
};

#define LIB_LAZY	1

struct lib_sym {
	__f_off name;		/* ptr to char */
	struct relocs reloc;
};

struct sym {
	__f_off name;
	__f_off value;
};

#endif
