#ifndef __SPAD_PIO_H
#define __SPAD_PIO_H

#include <SYS/TYPES.H>

#define PIO_CMD_MODE_MASK		0x00ff
#define PIO_CMD_NOACQ_MASK		0x0100
#define PIO_CMD_DETACH			0x0000
#define PIO_CMD_ATTACH_SOMETIMES	0x0010
#define PIO_CMD_ATTACH_SOMETIMES_NOACQ	(PIO_CMD_ATTACH_SOMETIMES | PIO_CMD_NOACQ_MASK)
#define PIO_CMD_ATTACH_MOST_TIME	0x0020
#define PIO_CMD_ATTACH_MOST_TIME_NOACQ	(PIO_CMD_ATTACH_MOST_TIME | PIO_CMD_NOACQ_MASK)
#define PIO_CMD_ATTACH_PERMANENT	0x0030

#define PIO_STATUS_ERROR	0x08
#define PIO_STATUS_SLCT		0x10
#define PIO_STATUS_PE		0x20
#define PIO_STATUS_ACK		0x40
#define PIO_STATUS_BUSY		0x80

#define PIO_CTL_STROBE		0x01
#define PIO_CTL_AUTO_LF		0x02
#define PIO_CTL_INIT		0x04
#define PIO_CTL_SLCT		0x08

#define PIO_ECR_MODE_STANDARD		0x00
#define PIO_ECR_MODE_BYTE		0x20
#define PIO_ECR_MODE_FIFO		0x40
#define PIO_ECR_MODE_ECP_FIFO		0x60
#define PIO_ECR_MODE_EPP		0x80
#define PIO_MODE_NONBLOCK		0x8000

struct pio_client;

struct pio_operations {
	MTX *(*acquire)(struct pio_client *);
	void (*release)(struct pio_client *);
	int (*want_release)(struct pio_client *);
	int (*set_mode)(struct pio_client *, unsigned );
	__u8 (*get_status)(struct pio_client *);
	void (*set_ctl)(struct pio_client *, __u8 );
	void (*set_data)(struct pio_client *, __u8 );
	MTX *(*enable_irq)(struct pio_client *);
	int (*wait_sync)(struct pio_client *pc, __u8 status, __u8 mask, jiffies_lo_t timeout);
	int (*write_data_sync)(struct pio_client *, __u8 *, int);
};

struct pio_client {
	void *opaque;
	void *opaque_2;
	unsigned short size_of_pio_operations;
	unsigned short size_of_pio_client;
	__const__ struct pio_operations *op;
	unsigned long net_id;
	void (*fast_irq_upcall)(struct pio_client *);
};

#endif
