#ifndef __SPAD_SCSI_H
#define __SPAD_SCSI_H

#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>
#include <SPAD/BIO.H>
#include <SPAD/TIMER.H>

typedef struct __scsirq SCSIRQ;

#define SCSIRQ_HEAD						\
	int status;						\
	unsigned ch_id_lun;					\
	void *adapter;						\
	BIODESC *desc; /* must be preserved by the host driver */\
	unsigned long internal;	/* internal to host adapter */	\
	void (*done)(SCSIRQ *);					\
	__u8 *sense;						\
	__u8 sense_size;					\
	__u8 scsi_status;					\
	__u8 direction;						\
		/* 0 --- no transfer */				\
		/* PF_WRITE --- from device to memory */	\
		/* PF_READ --- from memory to device */		\
	__u8 cmdlen;						\
	__u8 pad[2]

#define SCSI_GOOD			0x00
#define SCSI_CHECK_CONDITION		0x02
#define SCSI_CONDITION_MET		0x04
#define SCSI_BUSY			0x08
#define SCSI_INTERMEDIATE		0x10
#define SCSI_INTERMEDIATE_CONDITION_MET	0x14
#define SCSI_RESERVATION_CONFLICT	0x18
#define SCSI_COMMAND_TERMINATED		0x22
#define SCSI_QUEUE_FULL			0x28
#define SCSI_ACA_ACTIVE			0x30
#define SCSI_TASK_ABORTED		0x40

#define DECL_SCSIRQ(n)			\
	struct {			\
		SCSIRQ_HEAD;		\
		__u8 cmd[n];		\
	}

struct __scsirq {
	SCSIRQ_HEAD;
	__u8 cmd[1];
};

typedef struct __scsi_attach_param SCSI_ATTACH_PARAM;

struct __scsi_attach_param {
	/* sd -> host adapter */
	unsigned version;
	jiffies_lo_t probe_timeout;
	jiffies_lo_t timeout;
	char *msg;	/* exception: host adapter -> sd */
	char *param;
	char *dev_prefix;

	/* host adapter -> sd (sd should zero these on 1st attempt) */
	char (*dev_name)[__MAX_STR_LEN];
	void *adapter;
	short biosched;	/* exception: sd -> host adapter */
	__u8 scsi_flags;
	__u8 lun;
	unsigned ch_id_lun;
	unsigned max_sectors;		/* max rq size in 512-byte units */
	unsigned short max_tags;
	unsigned short max_fragments;	/* max number of entries in BIODESC chain */
	int (*post)(SCSIRQ *);
	void (*cancel)(SCSIRQ *);

	/* sd -> host adapter */
	int (*dequeue)(SCSI_ATTACH_PARAM *);
	BIORQ *(*probe_queue)(SCSI_ATTACH_PARAM *);
};

#define SCSI_VERSION		(1 | (sizeof(SCSIRQ) << 16) | (sizeof(SCSI_ATTACH_PARAM) << 24))

#define SCSI_CMD_GET		0
#define SCSI_CMD_FREE		1

#define SCSI_FLAG_CAN_USE_MODE_6	0x01
#define SCSI_FLAG_CAN_USE_MODE_10	0x02
#define SCSI_FLAG_SHORT_INQUIRY		0x04


#define SCSI_CONTROL_LINK		0x01
#define SCSI_CONTROL_FLAG		0x02
#define SCSI_CONTROL_NACA		0x04
#define SCSI_CONTROL_VENDOR_SPECIFIC	0xc0


typedef struct {
	__u8 type;
#define INQ_TYPE_TYPE			0x1f
#define INQ_TYPE_QUAL			0xe0
#define  INQ_TYPE_QUAL_CONNECTED	 0x00
#define  INQ_TYPE_QUAL_DISCONNECTED	 0x20
#define  INQ_TYPE_QUAL_INVALID_LUN	 0x60
	__u8 rmb;
#define INQ_RMB_RMB			0x80
	__u8 version;
	__u8 flags0;
#define INQ_FLAGS0_RESPONSE_DATA_FORMAT	0x0f
#define INQ_FLAGS0_HISUP		0x10
#define INQ_FLAGS0_NORMACA		0x20
#define INQ_FLAGS0_TRMIOP		0x40	/* == SCSI 2 */
#define INQ_FLAGS0_AENC			0x80	/* == SCSI 2 */
#define INQ_FLAGS0_AERC			0x80	/* >= SCSI 3/SPC2 */
	__u8 additional_length;
	__u8 flags1;
#define INQ_FLAGS1_PROTECT		0x01
#define INQ_FLAGS1_3PC			0x08
#define INQ_FLAGS1_TPGS			0x30
#define INQ_FLAGS1_ACC			0x40
#define INQ_FLAGS1_SCCS			0x80
	__u8 flags2;
#define INQ_FLAGS2_ADDR16		0x01
#define INQ_FLAGS2_MCHNGR		0x08
#define INQ_FLAGS2_MULTIP		0x10
#define INQ_FLAGS2_VS			0x20
#define INQ_FLAGS2_ENCSERV		0x40
#define INQ_FLAGS2_BQUE			0x80
	__u8 flags3;
#define INQ_FLAGS3_SFTRE		0x01	/* == SCSI 2 */
#define INQ_FLAGS3_CMDQUE		0x02
#define INQ_FLAGS3_LINKED		0x08
#define INQ_FLAGS3_SYNC			0x10
#define INQ_FLAGS3_WBUS16		0x20
#define INQ_FLAGS3_WBUS32		0x40	/* == SCSI 2 || SCSI 3/SPC 1 */
#define INQ_FLAGS3_RELADR		0x80
	__u8 vendor[8];
	__u8 product[16];
	__u8 revision[4];
	__u8 vendor_specific[20];
	__u8 flags_spi;
#define INQ_FLAGS_SPI_IUS		0x01
#define INQ_FLAGS_SPI_QAS		0x02
#define INQ_FLAGS_SPI_CLOCKING		0x0c
	__u8 reserved_1;
	__u16 standard_descs[8];
	__u8 reserved_2[22];
} SCSI_INQUIRY_DATA;

#define SCSI_MIN_INQUIRY_SIZE		5
#define SCSI_SHORT_INQUIRY_SIZE		36

#define SCSI_TYPE_DA			0x00
#define SCSI_TYPE_SA			0x01
#define SCSI_TYPE_PRINTER		0x02
#define SCSI_TYPE_PROCESSOR		0x03
#define SCSI_TYPE_WORM			0x04
#define SCSI_TYPE_CD_DVD		0x05
#define SCSI_TYPE_SCANNER		0x06
#define SCSI_TYPE_OPTICAL_DA		0x07
#define SCSI_TYPE_JUKEBOX		0x08
#define SCSI_TYPE_COMMUNICATIONS	0x09
#define SCSI_TYPE_RAID			0x0c
#define SCSI_TYPE_ENCLOSURE		0x0d
#define SCSI_TYPE_REDUCED_DA		0x0e
#define SCSI_TYPE_OPTICAL_CARD_RW	0x0f
#define SCSI_TYPE_BRIDGE		0x10
#define SCSI_TYPE_OBJECT_STORAGE	0x11
#define SCSI_TYPE_AUTOMATION_DRIVE	0x12
#define SCSI_TYPE_WELL_KNOWN_LUN	0x1e
#define SCSI_TYPE_UNKNOWN		0x1f

#define SCSI_VERSION_NONE		0x00
#define SCSI_VERSION_SPC		0x03
#define SCSI_VERSION_SPC_2		0x04
#define SCSI_VERSION_SPC_3		0x05


typedef struct {
	__u8 response_code;
#define SENSE_RESPONSE_CODE		0x7f
#define SENSE_RESPONSE_CODE_CURRENT	0x70
#define SENSE_RESPONSE_CODE_DEFERRED	0x71
#define SENSE_RESPONSE_CODE_DEFERRED_BIT	0x01
#define SENSE_RESPONSE_CODE_DESC_CURRENT	0x72
#define SENSE_RESPONSE_CODE_DESC_DEFERRED	0x73
#define SENSE_INFORMATION_VALID		0x80
	__u8 segment_number;		/* == SCSI 2 */
	__u8 flags;
#define SENSE_FLAGS_SENSE_KEY		0x0f
#define SENSE_FLAGS_ILI			0x20
#define SENSE_FLAGS_EOM			0x40
#define SENSE_FLAGS_FILEMARK		0x80
	__u8 information[4];
	__u8 additional_length;
	__u32 command_specific;
	__u8 asc;
	__u8 ascq;
	__u8 field_replaceable_unit_code;
	__u8 sense_key_specific[3];
#define SENSE_KEY_SPECIFIC_VALID	0x80
} SCSI_SENSE_DATA;

#define SCSI_SIZEOF_SENSE_DATA		18

typedef struct {
	__u8 flags;
#define SENSE1_FLAGS_ERROR_CODE		0x0f
#define SENSE1_FLAGS_ERROR_CLASS	0x70
#define SENSE1_FLAGS_ADVALID		0x80
	__u8 lba3;
#define SENSE1_LBA3_LBA3		0x1f
#define SENSE1_LBA3_VENDOR_UNIQUE	0xe0
	__u8 lba2;
	__u8 lba1;
} SCSI1_SENSE_DATA;

#define SCSI_MIN_REQUEST_SENSE_SIZE	4

#define SCSI_KEY_NO_SENSE		0
#define SCSI_KEY_RECOVERED_ERROR	1
#define SCSI_KEY_NOT_READY		2
#define SCSI_KEY_MEDIUM_ERROR		3
#define SCSI_KEY_HARDWARE_ERROR		4
#define SCSI_KEY_ILLEGAL_REQUEST	5
#define SCSI_KEY_UNIT_ATTENTION		6
#define SCSI_KEY_DATA_PROTECT		7
#define SCSI_KEY_BLANK_CHECK		8
#define SCSI_KEY_VENDOR_SPECIFIC	9
#define SCSI_KEY_COPY_ABORTED		10
#define SCSI_KEY_ABORTED_COMMAND	11
#define SCSI_KEY_EQUAL			12	/* <= SCSI 2 */
#define SCSI_KEY_VOLUME_OVERFLOW	13
#define SCSI_KEY_MISCOMPARE		14

typedef struct {
	__u32 lba;
	__u32 sector_size;
} SCSI_CAPACITY_10;

#define SCSI_MIN_CAPACITY_10_SIZE	8

typedef struct {
	__u64 lba;
	__u32 sector_size;
	__u8 flags;
#define SCSI_CAPACITY_16_FLAGS_PROT_EN	0x01
#define SCSI_CAPACITY_16_FLAGS_RTO_EN	0x02
	__u8 reserved[19];
} SCSI_CAPACITY_16;

#define SCSI_MIN_CAPACITY_16_SIZE	13

typedef struct {
	__u16 data_length;
	__u8 medium_type;
	__u8 device_specific;
	__u8 reserved1;
	__u8 reserved2;
	__u16 block_descriptor_length;
} SCSI_MODE_SENSE_HEADER;

typedef struct {
	__u8 data_length;
	__u8 medium_type;
	__u8 device_specific;
	__u8 block_descriptor_length;
} SCSI_MODE_SENSE_6_HEADER;

/* SCSI 1 common */
#define SCMD_TEST_UNIT_READY		0x00
#define SCMD_REQUEST_SENSE		0x03
#define SCMD_INQUIRY			0x12
#define SCMD_MODE_SELECT_6		0x15
#define SCMD_COPY			0x18
#define SCMD_MODE_SENSE_6		0x1a
#define SCMD_RECEIVE_DIAGNOSTIC_RESULTS	0x1c
#define SCMD_SEND_DIAGNOSTIC		0x1d
#define SCMD_PREVENT_ALLOW_MEDIUM_REMOVAL	0x1e
#define SCMD_COMPARE			0x39
#define SCMD_COPY_AND_VERIFY		0x3a

/* SCSI 1 DA, WORM, Read-only */
#define SCMD_REZERO_UNIT		0x01
#define SCMD_FORMAT_UNIT		0x04
#define SCMD_REASSIGN_BLOCKS		0x07
#define SCMD_READ_6			0x08
#define SCMD_WRITE_6			0x0a
#define SCMD_SEEK_6			0x0b
#define SCMD_RESERVE_6			0x16
#define SCMD_RELEASE_6			0x17
#define SCMD_START_STOP_UNIT		0x1b
#define SCMD_READ_CAPACITY_10		0x25
#define SCMD_READ_10			0x28
#define SCMD_WRITE_10			0x2a
#define SCMD_SEEK_10			0x2b
#define SCMD_WRITE_AND_VERIFY_10	0x2e
#define SCMD_VERIFY_10			0x2f
#define SCMD_SEARCH_DATA_HIGH_10	0x30
#define SCMD_SEARCH_DATA_EQUAL_10	0x31
#define SCMD_SEARCH_DATA_LOW_10		0x32
#define SCMD_SET_LIMITS_10		0x33

/* SCSI 1 SA */
#define SCMD_SA_REWIND			0x01
#define SCMD_SA_READ_BLOCK_LIMITS	0x05
#define SCMD_SA_READ			0x08
#define SCMD_SA_WRITE			0x0a
#define SCMD_SA_TRACK_SELECT		0x0b
#define SCMD_SA_READ_REVERSE		0x0f
#define SCMD_SA_WRITE_FILEMARKS		0x10
#define SCMD_SA_SPACE			0x11
#define SCMD_SA_VERIFY			0x13
#define SCMD_SA_RECOVER_BUFFERED_DATA	0x14
#define SCMD_RESERVE_UNIT		0x16
#define SCMD_RELEASE_UNIT		0x17
#define SCMD_SA_ERASE			0x19
#define SCMD_SA_LOAD_UNLOAD		0x1b

/* SCSI 1 Printer */
#define SCMD_PRN_FORMAT			0x04
#define SCMD_PRN_PRINT			0x0a
#define SCMD_PRN_SLEW_AND_PRINT		0x0b
#define SCMD_FLUSH_BUFFER		0x10
#define SCMD_PRN_RECOVER_BUFFERED_DATA	0x14
#define SCMD_RESERVE_UNIT		0x16
#define SCMD_RELEASE_UNIT		0x17
#define SCMD_PRN_STOP_PRINT		0x1b

/* SCSI 1 Processor */
#define SCMD_PROC_RECEIVE		0x08
#define SCMD_PROC_SEND			0x0a

/* SCSI 2 common */
#define SCMD_WRITE_BUFFER		0x3b
#define SCMD_READ_BUFFER		0x3c
#define SCMD_CHANGE_DEFINITION		0x40
#define SCMD_LOG_SELECT			0x4c
#define SCMD_LOG_SENSE			0x4d
#define SCMD_MODE_SELECT_10		0x55
#define SCMD_MODE_SENSE_10		0x5a

/* SCSI 2 DA */
#define SCMD_PREFETCH_10		0x34
#define SCMD_SYNCHRONIZE_CACHE_10	0x35
#define SCMD_LOCK_UNLOCK_CACHE		0x36
#define SCMD_READ_DEFECT_DATA_10	0x37
#define SCMD_READ_LONG_10		0x3e
#define SCMD_WRITE_LONG_10		0x3f
#define SCMD_WRITE_SAME_10		0x41

/* SCSI 2 SA */
#define SCMD_SA_LOCATE			0x2b
#define SCMD_SA_READ_POSITION		0x34

/* SCSI 2 WORM */
#define SCMD_READ_12			0xa8
#define SCMD_WRITE_12			0xaa
#define SCMD_WRITE_AND_VERIFY_12	0xae
#define SCMD_VERIFY_12			0xaf
#define SCMD_SEARCH_DATA_HIGH_12	0xb0
#define SCMD_SEARCH_DATA_EQUAL_12	0xb1
#define SCMD_SEARCH_DATA_LOW_12		0xb2
#define SCMD_SET_LIMITS_12		0xb3

/* SCSI 2 CD */

#define SCMD_CD_READ_CAPACITY_10	0x25
#define SCMD_CD_READ_SUB_CHANNEL	0x42
#define SCMD_CD_READ_TOC		0x43
#define SCMD_CD_READ_HEADER		0x44
#define SCMD_CD_PLAY_AUDIO_10		0x45
#define SCMD_CD_PLAY_AUDIO_MSF		0x47
#define SCMD_CD_PLAY_AUDIO_TRACK_INDEX	0x48
#define SCMD_CD_PLAY_TRACK_RELATIVE	0x49
#define SCMD_CD_PAUSE_RESUME		0x4b
#define SCMD_CD_PLAY_AUDIO_12		0xa5
#define SCMD_CD_PLAY_TRACK_RELATIVE_12	0xa9

/* SCSI 2 Scanner */

#define SCMD_SCN_SCAN			0x1b
#define SCMD_SCN_SET_WINDOW		0x24
#define SCMD_SCN_GET_WINDOW		0x25
#define SCMD_SCN_READ			0x28
#define SCMD_SCN_SEND			0x2a
#define SCMD_SCN_OBJECT_POSITION	0x31
#define SCMD_SCN_GET_DATA_BUFFER_STATUS	0x34

/* SCSI 2 Optical */

#define SCMD_OPT_READ_GENERATION	0x29
#define SCMD_OPT_ERASE_10		0x2c
#define SCMD_OPT_READ_UPDATED_BLOCK	0x2d
#define SCMD_OPT_MEDIUM_SCAN		0x38
#define SCMD_OPT_UPDATE_BLOCK		0x3d
#define SCMD_OPT_ERASE_12		0xac
#define SCMD_READ_DEFECT_DATA_12	0xb7

/* SCSI 2 Media Changer */

#define SCMD_MCHG_INITIALIZE_ELEMENT_STATUS	0x07
#define SCMD_MCHG_POSITION_TO_ELEMENT	0x2b
#define SCMD_MCHG_MOVE_MEDIUM		0xa5
#define SCMD_MCHG_EXCHANGE_MEDIUM	0xa6
#define SCMD_MCHG_REQUEST_VOLUME_ELEMENT_ADDRESS	0xb5
#define SCMD_MCHG_SEND_VOLUME_TAG	0xb6
#define SCMD_MCHG_READ_ELEMENT_STATUS	0xb8

/* SCSI 2 Communication */

#define SCMD_COMM_GET_MESSAGE_6		0x08
#define SCMD_COMM_GET_MESSAGE_10	0x28
#define SCMD_COMM_GET_MESSAGE_12	0xa8
#define SCMD_COMM_SEND_MESSAGE_6	0x0a
#define SCMD_COMM_SEND_MESSAGE_10	0x2a
#define SCMD_COMM_SEND_MESSAGE_12	0xaa

/* SCSI 3 SPC */

#define SCMD_PERSISTENT_RESERVE_IN	0x5e
#define SCMD_PERSISTENT_RESERVE_OUT	0x5f
#define SCMD_REPORT_LUNS		0xa0
#define SCMD_MOVE_MEDIUM_ATTACHED	0xa7
#define SCMD_READ_ELEMENT_STATUS_ATTACHED	0xb4
#define SCMD_RESERVE_10			0x56
#define SCMD_RELEASE_10			0x57

/* SCSI 3 SPC 2 */

#define SCMD_EXTENDED_COPY		0x83
#define SCMD_RECEIVE_COPY_RESULTS	0x84
#define SCMD_REPORT_DEVICE_IDENTIFIER	0xa3
#define  SCMDSA_REPORT_DEVICE_IDENTIFIER	0x05
#define SCMD_SET_DEVICE_IDENTIFIER	0xa4
#define  SCMDSA_SET_DEVICE_IDENTIFIER		0x06

/* SCSI 3 SPC 3 */

#define SCMD_ACCESS_CONTROL_IN		0x86
#define SCMD_ACCESS_CONTROL_OUT		0x87
#define SCMD_READ_ATTRIBUTE		0x8c
#define SCMD_REPORT_TARGET_PORT_GROUPS			0xa3
#define  SCMDSA_REPORT_TARGET_PORT_GROUPS			0x0a
#define SCMD_REPORT_ALIASES				0xa3
#define  SCMDSA_REPORT_ALIASES					0x0b
#define SCMD_REPORT_SUPPORTED_OPERATION_CODES		0xa3
#define  SCMDSA_REPORT_SUPPORTED_OPERATION_CODES		0x0c
#define SCMD_REPORT_SUPPORTED_TASK_MANAGEMENT_FUNCTIONS	0xa3
#define  SCMDSA_REPORT_SUPPORTED_TASK_MANAGEMENT_FUNCTIONS	0x0d
#define SCMD_REPORT_PRIORITY				0xa3
#define  SCMDSA_REPORT_PRIORITY					0x0e
#define SCMD_REPORT_TIMESTAMP				0xa3
#define  SCMDSA_REPORT_TIMESTAMP				0x0f
#define SCMD_SET_TARGET_PORT_GROUPS			0xa4
#define  SCMDSA_SET_TARGET_PORT_GROUPS				0x0a
#define SCMD_CHANGE_ALIAS				0xa4
#define  SCMDSA_CHANGE_ALIAS					0x0b
#define SCMD_SET_PRIORITY				0xa4
#define  SCMDSA_SET_PRIORITY					0x0e
#define SCMD_SET_TIMESTAMP				0xa4
#define  SCMDSA_SET_TIMESTAMP					0x0f
#define SCMD_READ_MEDIA_SERIAL_NUMBER			0xab
#define  SCMDSA_READ_MEDIA_SERIAL_NUMBER			0x01

/* SCSI 3 SBC */

#define SCMD_XDWRITE_10			0x50
#define SCMD_XPWRITE_10			0x51
#define SCMD_XDREAD_10			0x52
#define SCMD_XDWRITE_EXTENDED		0x80
#define SCMD_REBUILD			0x81
#define SCMD_REGENERATE			0x82

/* SCSI 3 SBC 2 */

#define SCMD_XDWRITEREAD_10		0x53
#define SCMD_XDREAD_32			0x7f
#define  SCMDSA_XDREAD_32			0x0003
#define SCMD_XDWRITE_32			0x7f
#define  SCMDSA_XDWRITE_32			0x0004
#define SCMD_XPWRITE_32			0x7f
#define  SCMDSA_XPWRITE_32			0x0006
#define SCMD_XDWRITEREAD_32		0x7f
#define  SCMDSA_XDWRITEREAD_32			0x0007
#define SCMD_READ_32			0x7f
#define  SCMDSA_READ_32				0x0009
#define SCMD_VERIFY_32			0x7f
#define  SCMDSA_VERIFY_32			0x000a
#define SCMD_WRITE_32			0x7f
#define  SCMDSA_WRITE_32			0x000b
#define SCMD_WRITE_AND_VERIFY_32	0x7f
#define  SCMDSA_WRITE_AND_VERIFY_32		0x000c
#define SCMD_READ_16			0x88
#define SCMD_WRITE_16			0x8a
#define SCMD_WRITE_AND_VERIFY_16	0x8e
#define SCMD_VERIFY_16			0x8f
#define SCMD_PREFETCH_16		0x90
#define SCMD_SYNCHRONIZE_CACHE_16	0x91
#define SCMD_WRITE_SAME_16		0x93
#define SCMD_READ_CAPACITY_16		0x9e
#define  SCMDSA_READ_CAPACITY_16		0x10
#define SCMD_READ_LONG_16		0x9e
#define  SCMDSA_READ_LONG_16			0x11
#define SCMD_WRITE_LONG_16		0x9f
#define  SCMDSA_WRITE_LONG_16			0x11
#define SCMD_MAINTENANCE_IN		0xa3
#define SCMD_MAINTENANCE_OUT		0xa4
#define SCMD_REDUNDANCY_GROUP_IN	0xba
#define SCMD_REDUNDANCY_GROUP_OUT	0xbb
#define SCMD_SPARE_IN			0xbc
#define SCMD_SPARE_OUT			0xbd
#define SCMD_VOLUME_SET_IN		0xbe
#define SCMD_VOLUME_SET_OUT		0xbf

/* UFI 1.0 */

#define SCMD_READ_FORMAT_CAPACITIES	0x23


__u8 SCSI$VERSION(__const__ SCSI_INQUIRY_DATA *inq);
int SCSI$SUPPORTS_STD(__const__ SCSI_INQUIRY_DATA *inq, ...);
void SCSI$SYNC_RQ(__const__ char *dev_name, int errorlevel, char *cmdstring, SCSIRQ *rq, SCSI_ATTACH_PARAM *ap, void *ptr, unsigned long len, jiffies_lo_t timeout, int retries, int (*action)(SCSIRQ *rq));

__u32 SCSI$GET_SENSE(__const__ SCSI_SENSE_DATA *sense, unsigned sense_size);
__u32 SCSI$GET_CMD_SENSE(__const__ SCSIRQ *rq);
#define SCSI_SENSE_UNKNOWN(key)		((key) == 0xffffffff)
#define SCSI_SENSE_DEFERRED(key)	((key) & 0x10)
#define SCSI_SENSE_KEY(key)		((key) & 0x0f)
#define SCSI_SENSE_ASC(key)		(((key) >> 16) & 0xff)
#define SCSI_SENSE_ASCQ(key)		((key) >> 24)
#define SCSI_SENSE_KEY_OK(key)		(SCSI_SENSE_KEY(key) == SCSI_KEY_NO_SENSE || SCSI_SENSE_KEY(key) == SCSI_KEY_RECOVERED_ERROR)
#define SCSI_SENSE_KEY_MEDIA(key)	(SCSI_SENSE_KEY(key) == SCSI_KEY_MEDIUM_ERROR || SCSI_SENSE_KEY(key) == SCSI_KEY_DATA_PROTECT || SCSI_SENSE_KEY(key) == SCSI_KEY_BLANK_CHECK || SCSI_SENSE_KEY(key) == SCSI_KEY_VOLUME_OVERFLOW)
__const__ char *SCSI$SENSE_ASC_STRING(__u8 asc, __u8 ascq);
__const__ char *SCSI$SENSE_STRING(__u8 scsi_version, __const__ SCSI_SENSE_DATA *sense, unsigned sense_size);
__const__ char *SCSI$STATUS_STRING(__u8 status);

int SCSI$RECOMMENDED_ACTION(SCSIRQ *srq);
#define SCSI_ACTION_OK			0
#define SCSI_ACTION_RETRY_UNTIL_TIMEOUT	1
#define SCSI_ACTION_RETRY_FEW_TIMES	2
#define SCSI_ACTION_FAIL		3

int SCSI$SENSE_ERROR_CODE(__u8 scsi_version, __const__ SCSI_SENSE_DATA *sense, unsigned sense_size);
int SCSI$STATUS_ERROR_CODE(__u8 scsi_status);
int SCSI$CMD_ERROR_CODE(__u8 scsi_version, __const__ SCSIRQ *srq);
void SCSI$LOG_ERROR(__const__ char *dev_name, int errorlevel, __const__ SCSI_INQUIRY_DATA *inq, __u8 scsi_version, __const__ char *cmdstring, __const__ SCSIRQ *rq, int error);
void SCSI$LOG_RECOVERED_ERROR(__const__ char *dev_name, int errorlevel, __const__ char *cmdstring, __const__ SCSIRQ *rq);
__sec_t SCSI$SENSE_LBA(__u8 scsi_version, __const__ SCSI_SENSE_DATA *sense, unsigned sense_size);
__sec_t SCSI$CMD_LBA(__u8 scsi_version, __const__ SCSIRQ *srq);

int SCSI$INQUIRY(__const__ char *dev_name, int errorlevel, SCSI_ATTACH_PARAM *ap, __u8 lun_byte, void *data, unsigned datalen, jiffies_lo_t timeout);
void SCSI$GET_MODEL(SCSI_INQUIRY_DATA *inq, char (*vendor)[9], char (*product)[17], char (*revision)[5]);
SCSI_MODE_SENSE_HEADER *SCSI$MODE_SENSE(__const__ char *dev_name, int errorlevel, __const__ SCSI_INQUIRY_DATA *inq, __u8 scsi_version, SCSI_ATTACH_PARAM *ap, __u8 lun_byte, int modepage, unsigned len, jiffies_lo_t timeout, int retries);
SCSI_MODE_SENSE_HEADER *SCSI$MODE_SENSE_PAGE(__const__ char *dev_name, int errorlevel, __const__ SCSI_INQUIRY_DATA *inq, __u8 scsi_version, SCSI_ATTACH_PARAM *ap, __u8 lun_byte, int modepage, unsigned *len, jiffies_lo_t timeout, int retries);

#endif
