#ifndef __SPAD_SHELL_H
#define __SPAD_SHELL_H

#include <SPAD/AC.H>
#include <SPAD/LIBC.H>
#include <SPAD/ALLOC.H>
#include <SPAD/DEV.H>
#include <SPAD/THREAD.H>
#include <SPAD/LIST.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

#define _SHELL_STACK_SIZE	8

typedef struct __shell_context CTX;

typedef struct __shrcrq SHRCRQ;

struct __shrcrq {
	IORQ_HEAD;
	CTX *ctx;
	__const__ char *ptr;
	int len;
	__const__ char **arg;
	int narg;

	__const__ char *error_msg;	/* shell places a pointer here */

	__const__ char *pos;	/* these are used internally */
	__const__ char *stack[_SHELL_STACK_SIZE];
	SHRCRQ *link;
	THREAD_RQ trq;
	XLIST_HEAD local;
};

extern IO_STUB SHELL$RUN_COMMANDS;

typedef struct {
	IORQ_HEAD;
	CTX *ctx;
	MALLOC_REQUEST mrq;
} SHCCRQ;

extern IO_STUB SHELL$CREATE_CONTEXT;
void SHELL$DESTROY_CONTEXT(CTX *ctx);

void SHELL$SET_TTY(CTX *ctx, int std_in, int std_out, int std_err, char std_in_tty, char std_out_tty, char std_err_tty, char no_close);
void SHELL$SET_CWD(CTX *ctx, CWD *cwd, int no_free);

void SHELL$ESC_COPY(char *dest, __const__ char *src);

__END_DECLS

#endif
