#ifndef __SPAD_SHELLM_H
#define __SPAD_SHELLM_H

#include <SPAD/AC.H>
#include <SPAD/ALLOC.H>
#include <SPAD/DEV.H>
#include <SPAD/DL.H>
#include <SPAD/READDIR.H>
#include <SYS/STAT.H>
#include <SPAD/CD.H>
#include <SPAD/LIBPROC.H>
#include <SPAD/THREAD.H>
#include <SYS/TYPES.H>
#include <TERMIOS.H>
#include <SPAD/TTY.H>

#include <SPAD/SHELL.H>

__BEGIN_DECLS

typedef void (*cmdthread_t)(CTX *ctx);

typedef struct {
	char *name;
	int flags;
	union {
		AST_STUB *command;
		cmdthread_t thread;
	} u;
} CMD;

#define CMDF_DONT_CLEAR_STATUS	1
#define CMDF_SYNC_COMMAND	2

#define PRIO_BRACKET	10
#define PRIO_LOWEST	20
#define PRIO_OR		20
#define PRIO_AND	30
#define PRIO_NOT	40
#define PRIO_COMPARE	50
#define PRIO_PLUS	60
#define PRIO_CONCAT	70
#define PRIO_MULTIPLY	80
#define PRIO_POWER	90
#define PRIO_FUNCTION	100

typedef char *function_t(CTX *ctx, int args, char **a1, char *fn);

typedef struct {
	char *name;
	int priority;
	int arguments;
	function_t *function;
} FUNCTION;

typedef struct __intx INTX;

struct __intx {
	SHRCRQ rc;
	char *buf;
	int buf_size;
	int buf_ptr;
	char doexit;
	char print_prompt;
	INTX *link;
};

#define VAR_HASH_SIZE	32

	/* must be >= __MAX_STR_LEN */
#define SCRATCH_1_LEN	__MAX_STR_LEN
#define SCRATCH_2_LEN	__MAX_STR_LEN

#define N_DIRECT_HISTORY	5
#define HISTORY_FILE		"HOME:/.SHELL_HISTORY"

#define PROMPT_PREFIX		"\013\e[10m"
#define ERR_PREFIX		"\013\e[10m"
#define ERR_PREFIX_LEN		6
#define COLOR_STRING_LEN	16	/* \[0;1;5;7;37;40m */

typedef __u16 shell_color_t;

struct __shell_context {
	/*
	 * I expect that all union members have offset 0
	 * in the structure. Is this ok according to the C standart?
	 */
	union {
		IORQ rq;
		MALLOC_REQUEST mrq;
		OPENRQ openrq;
		CLOSERQ closerq;
		SIORQ siorq;
		IOCTLRQ ioctlrq;
		DLIMGRQ imgrq;
		DCTLRQ dctlrq;
		LOGICAL_REQUEST lrq;
		CDRQ cdrq;
		PROC_SPAWN_RQ psr;
		PROC_CTRL_RQ pcr;
		SHCCRQ shccrq;
	} u;

	union {
		READDIR_RQ rddir_rq;
		LOGICAL_LIST_REQUEST llr;
		struct {
			IOCTLRQ wio;
			struct tty_control_state tcs;
		} w;
	} u2;
	struct stat stat;
	struct tty_window_size winsize;

	XLIST_HEAD var_hash[VAR_HASH_SIZE];
	CTX *var_chain;

	int ctty_in;
	int ctty_out;
	int ctty_err;
	char ctty_in_t;
	char ctty_out_t;
	char ctty_err_t;
	int ctty_in_orig;
	int ctty_out_orig;
	int ctty_err_orig;
	shell_color_t color;
	shell_color_t modified_color;

	CWD *cwd;
	CWD *cwd_orig;

	SHRCRQ *rq;
	INTX *intx;

	__const__ char *beg, *end, *pos;

	     /* actual buffer starts at command_buffer_end+command_buffer_len */
	char *command_buffer;
	int command_buffer_pos;

	     /* actual buffer starts at argv_buffer_end+argv_buffer_len */
	char **argv_buffer;
	int argv_buffer_pos;
	char **argv;	/* argv == argv_buffer; can be changed */

	char return_msg[__MAX_STR_LEN + ERR_PREFIX_LEN + COLOR_STRING_LEN + 1];
/* only __MAX_STR_LEN bytes (including terminating null) can be written here */
	int return_val;
	int return_ignore_err;

	int internal_flags;

	char *ctmp1;
	char *ctmp2;
	void *vtmp1;

	int itmp1;
	int itmp2;
	int itmp3;
	int itmp4;
	int itmp5;
	int itmp6;
	int itmp7;

	off_t otmp1;

	int *ptmp1;

	char scratch_1[SCRATCH_1_LEN];
	char scratch_2[SCRATCH_2_LEN];

	__const__ char *stack[_SHELL_STACK_SIZE];

	char *history[N_DIRECT_HISTORY];
	char last_job[9];
};

		/* internal_flags */
#define SHELL_IN_THREAD		1
#define SHELL_THREAD_ERROR	2
#define SHELL_DO_EXIT		4

extern AST_STUB SHELL$CONT_EXEC;
extern AST_STUB SHELL$DO_PARSED_COMMAND;

#define CALL_SHELL_FN(ctx, ast)				\
do {							\
	(ctx)->u.rq.fn = (ast);				\
	RETURN_AST(&(ctx)->u.rq);			\
} while (0)

#define RETURN_TO_SHELL(ctx) CALL_SHELL_FN(ctx, SHELL$CONT_EXEC)

int SHELL$REGISTER_COMMAND(CMD *cmd);
int SHELL$REGISTER_FUNCTION(FUNCTION *fn);
int SHELL$REGISTER_OPERATOR(FUNCTION *op);

__END_DECLS

#endif
