#ifndef __SPAD_SLAB_H
#define __SPAD_SLAB_H

#include <ARCH/SETUP.H>
#include <SYS/TYPES.H>
#include <ARCH/BSF.H>
#include <ARCH/SPL.H>
#include <STRING.H>

__BEGIN_DECLS

#if __DEBUG_MALLOC_SHORTAGE > 0
long int random(void);
#endif

extern __const__ int KERNEL$KERNEL;

struct __slhead;

#include <ARCH/SLAB.H>

#ifndef __static__
#define __static__ static
#endif

/* !!! WARNING: constructor cannot contruct first pointer of an object --- it is   used as a free-list link */

int KERNEL$SLAB_ENTRIES_PER_PAGE(unsigned size, unsigned align);
void KERNEL$SLAB_INIT(struct __slhead *__h, unsigned __size, unsigned __align, int __alloc_type, void (*__ctor)(void *__g, void *__o), void *__g, long *__limit, char *__name);
void KERNEL$SLAB_DESTROY(struct __slhead *__h);
int KERNEL$SLAB_EMPTY(struct __slhead *__h);
int KERNEL$SLAB_RESERVE(struct __slhead *__h, unsigned __n);
int KERNEL$SLAB_REAP(void);
void KERNEL$SLABS_DUMP(void);

struct __slentry *__MALLOC_ATTR__ KERNEL$__SLAB_ALLOC(struct __slhead *__h);
void KERNEL$__SLAB_FREE_PAGE(struct __slpage *__p);
void KERNEL$__SLAB_PARTIAL_PAGE(struct __slpage *__p);

void *__MALLOC_ATTR__ KERNEL$__REALLOC(void *__s, size_t __size);
void *__MALLOC_ATTR__ KERNEL$__CALLOC(size_t __s);
size_t KERNEL$__ALLOC_SIZE(void *__s);
void KERNEL$__MALLOC_ERROR(void);
void __SLAB_INIT_MALLOC_ARENA(void);

int KERNEL$MEMWAIT_SYNC(size_t __sz);

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ calloc(size_t __n, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ calloc(size_t __n, size_t __size)
{
	size_t __ss;
#if __DEBUG_MALLOC_SHORTAGE > 0
	if (__unlikely(KERNEL$KERNEL) && __unlikely((random() & 255) < __DEBUG_MALLOC_SHORTAGE)) return NULL;
#endif
	if (__is_constant(__size)) {
		if (__size > 1 && __unlikely(__n > (size_t)-1 / __size)) {
			__me:
			KERNEL$__MALLOC_ERROR();
			return NULL;
		}
		__ss = __n * __size;
	} else if (__is_constant(__n)) {
		if (__n > 1 && __unlikely(__size > (size_t)-1 / __n)) {
			goto __me;
		}
		__ss = __n * __size;
	} else {
		__calloc_multiply
	}
	return KERNEL$__CALLOC(__ss);
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ realloc(void *__s, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ realloc(void *__s, size_t __size)
{
	struct __slpage *__p;
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("realloc");
#endif
#if __DEBUG_MALLOC_SHORTAGE > 0
	if (__unlikely(KERNEL$KERNEL) && __unlikely((random() & 255) < __DEBUG_MALLOC_SHORTAGE)) return NULL;
#endif
	if (__unlikely(!((int)(unsigned long)__s & __PAGE_CLUSTER_SIZE_MINUS_1))) goto dorealloc;
	if (__unlikely(__nonstdheap(__s))) goto dorealloc;
	__p = (struct __slpage *)((unsigned long)__s & __NOT_PAGE_CLUSTER_SIZE_MINUS_1);
	if (__unlikely(__size > __p->__head->__objsize)) {
		dorealloc: __s = KERNEL$__REALLOC(__s, __size);
#ifdef __HEAP_CHECK
		KERNEL$HEAP_CHECK("realloc-out2");
#endif
		return __s;
	}
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("realloc-out1");
#endif
	return __s;
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ reallocf(void *__s, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ reallocf(void *__s, size_t __size)
{
	void *__v;
	struct __slpage *__p;
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("reallocf");
#endif
#if __DEBUG_MALLOC_SHORTAGE > 0
	if (__unlikely(KERNEL$KERNEL) && __unlikely((random() & 255) < __DEBUG_MALLOC_SHORTAGE)) {
		__slow_free(__s);
		return NULL;
	}
#endif
	if (__unlikely(!((int)(unsigned long)__s & __PAGE_CLUSTER_SIZE_MINUS_1))) goto dorealloc;
	if (__unlikely(__nonstdheap(__s))) goto dorealloc;
	__p = (struct __slpage *)((unsigned long)__s & __NOT_PAGE_CLUSTER_SIZE_MINUS_1);
	if (__unlikely(__size > __p->__head->__objsize)) {
		dorealloc:
		__v = KERNEL$__REALLOC(__s, __size);
		if (__unlikely(!__v)) __slow_free(__s);
#ifdef __HEAP_CHECK
		KERNEL$HEAP_CHECK("reallocf-out2");
#endif
		return __v;
	}
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("reallocf-out1");
#endif
	return __s;
}
#endif

#ifdef __NO_INLINES
size_t __alloc_size(void *__s);
#else
__static__ __finline__ size_t __alloc_size(void *__s)
{
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("__alloc_size");
#endif
	if (__unlikely(!((int)(unsigned long)__s & __PAGE_CLUSTER_SIZE_MINUS_1)) || __unlikely(__nonstdheap(__s))) return KERNEL$__ALLOC_SIZE(__s);
	return __slsize(__s);
}
#endif

void *__MALLOC_ATTR__ memalign(size_t __align, size_t __s);

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ valloc(size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ valloc(size_t __size)
{
	return memalign(__PAGE_CLUSTER_SIZE, __size);
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ malloc(size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ malloc(size_t __size)
{
	void *__r;
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("malloc");
#endif
#if __DEBUG_MALLOC_SHORTAGE > 0
	if (__unlikely(KERNEL$KERNEL) && __unlikely((random() & 255) < __DEBUG_MALLOC_SHORTAGE)) return NULL;
#endif
	__malloc_core(0);
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("malloc-out");
#endif
	return __r;
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __sync_malloc(size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __sync_malloc(size_t __size)
{
	void *__r;
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("__sync_malloc");
#endif
	__malloc_core(1);
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("__sync_malloc-out");
#endif
	return __r;
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __sync_calloc(size_t __n, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __sync_calloc(size_t __n, size_t __size)
{
	void *__p;
	while (__unlikely(!(__p = calloc(__n, __size)))) if (__unlikely(KERNEL$MEMWAIT_SYNC(__size))) return NULL;
	return __p;
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __sync_realloc(void *__s, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __sync_realloc(void *__s, size_t __size)
{
	void *__p;
	while (__unlikely(!(__p = realloc(__s, __size)))) if (__unlikely(KERNEL$MEMWAIT_SYNC(__size))) return NULL;
	return __p;
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __sync_reallocf(void *__s, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __sync_reallocf(void *__s, size_t __size)
{
	void *__p;
	while (__unlikely(!(__p = realloc(__s, __size)))) if (__unlikely(KERNEL$MEMWAIT_SYNC(__size))) {
		__slow_free(__s);
		return NULL;
	}
	return __p;
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __sync_memalign(size_t __align, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __sync_memalign(size_t __align, size_t __size)
{
	void *__p;
	while (__unlikely(!(__p = memalign(__align, __size)))) if (__unlikely(KERNEL$MEMWAIT_SYNC(__size))) return NULL;
	return __p;
}
#endif

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __sync_valloc(size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __sync_valloc(size_t __size)
{
	void *__p;
	while (__unlikely(!(__p = valloc(__size)))) if (__unlikely(KERNEL$MEMWAIT_SYNC(__size))) return NULL;
	return __p;
}
#endif

__END_DECLS

#endif
