#ifndef __SPAD_SOCKET_H
#define __SPAD_SOCKET_H

#include <SPAD/LIST.H>
#include <SPAD/DEV_KRNL.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef struct __netacl NETACL;
typedef struct __socket_node SOCKET_NODE;
typedef struct __socket_space SOCKET_SPACE;

#define SOCKET_NONBLOCK		1

#define SOCKET_HEAD				\
	LIST_ENTRY hash_entry;			\
	LIST_ENTRY node_entry;			\
	unsigned n;				\
	SOCKET_NODE *node;			\
	SOCKET_SPACE *space;			\
	__const__ HANDLE_OPERATIONS *op;	\
	int open_count;				\
	XLIST_HEAD handles;			\
	unsigned sock_flags;			\
	unsigned sock_sndbuf;			\
	unsigned sock_rcvbuf;			\
	unsigned sock_sndlowat;			\
	unsigned sock_rcvlowat;			\
	u_jiffies_lo_t sock_sndtimeo;		\
	u_jiffies_lo_t sock_rcvtimeo;		\
	u_jiffies_lo_t sock_lingertime;		\
	unsigned sock_type;			\
	int sock_error;				\

#define SOCK_RESETERROR		0x80000000U

typedef struct {
	SOCKET_HEAD
} SOCKET;

typedef struct {
	__u32 af;
	int sizeof_SOCKET;
	void (*ctor_SOCKET)(SOCKET *s);
	int (*init)(char **argv);
	void (*done)(void);
	__DCTL *dctl;
	int (*init_socket)(SOCKET *s, char *opt);
	void (*destroy_socket)(SOCKET *s);
	int (*close_socket)(SOCKET *s, IORQ *rq);
	void (*dup_socket)(SOCKET *s, SOCKET *os);
	int (*linger_socket)(SOCKET *s, IORQ *rq);
	int (*ioctl)(IOCTLRQ *rq);
	void *(*parse_netacl)(SOCKET_NODE *sn, char *str, NETACL **netacl);
	void *(*copy_netacl)(SOCKET_NODE *parent, NETACL **dest, NETACL *src);
	void (*free_netacl)(NETACL *netacl);
	void (*delete_offensive_sockets)(LIST_HEAD *socket_list);
} SOCKET_SPACE_OPERATIONS;

int NET$CREATE_SOCKET_SPACE(int argc, char *argv[], __const__ SOCKET_SPACE_OPERATIONS *op, char *driver_name);

int NET$QALLOC(SOCKET *s, unsigned len);
void NET$QFREE(SOCKET *s, unsigned len);
void NET$DESTROY_SOCKET(SOCKET *s);
void *NET$SOCKET_LOOKUP(HANDLE *h, char *str, int open_flags);
void *NET$SOCKET_INSTANTIATE(HANDLE *h, IORQ *rq, int open_flags);
void NET$SOCKET_DETACH(HANDLE *h);
int NET$SOCKET_CLOSE(HANDLE *h, IORQ *rq);
int NET$SOCKET_IOCTL(IOCTLRQ *rq);

SOCKET *NET$SOCKET_CREATE_SIBLING(SOCKET *os);

WQ *NET$OOM_NODE_SOCKET(SOCKET_NODE *sn, SOCKET *s);

static __finline__ char fixup_sock_char(char c)
{
	if (__unlikely(!c) || __unlikely((unsigned char)c == 255)) c = 1;
	else if (__unlikely(c == ':')) c = ':' + 1;
	else if (__unlikely(c == '/')) c = '/' + 1;
	return c;
}

static __finline__ void inc_csock(char *csock)
{
	if (__likely((csock[0] = fixup_sock_char(csock[0] + 1)) != 1)) return;
	if (__likely((csock[1] = fixup_sock_char(csock[1] + 1)) != 1)) return;
	if (__likely((csock[2] = fixup_sock_char(csock[2] + 1)) != 1)) return;
	csock[3] = fixup_sock_char(csock[3] + 1);
}

#define NETACL_END		((void *)1UL)
NETACL *NET$GET_NETACL(SOCKET_NODE **sn);
void NET$FOR_ALL_SOCKETS(SOCKET_NODE *sn, void (*fn)(SOCKET *s));

__END_DECLS

#endif
