#ifndef __SPAD_SWAPPER_H
#define __SPAD_SWAPPER_H

#include <SYS/TYPES.H>
#include <SPAD/LINK.H>
#include <SPAD/LIBC.H>

#include <SHA256.H>

	/* This can be changed to use different hash algorithm */
#define REL_DIGEST_LENGTH	SHA256_DIGEST_LENGTH
#define REL_CTX			SHA256_CTX
#define REL_Init		SHA256_Init
#define REL_Update		SHA256_Update
#define REL_Update		SHA256_Update
#define REL_Final		SHA256_Final

typedef struct {
	char error[__MAX_STR_LEN];
} LD_GET_ERROR;

typedef struct {
	unsigned long from;
	unsigned long to;
} LD_PREPARE;

typedef struct {
	unsigned iface;
} LD_SET_IFACE;

typedef struct {
	unsigned start;
	__f_off data[1];
		/* __f_off is here just to force correct alignment */
} LD_SET_SYMBOLS;

typedef struct {
	__f_off value;
	unsigned char namelen;	/* 0 --- end */
	char name[1];
} LD_SET_SYMBOLS_RECORD;

#define LD_SET_SYMBOLS_RECORD_LEN(namelen)	(((namelen) + 1 + sizeof(__f_off) + sizeof(__f_off) - 1) & ~(sizeof(__f_off) - 1))

typedef struct {
	__u8 hash[LINK_HASH_LENGTH + REL_DIGEST_LENGTH];
} LD_FINAL_HASH;

typedef struct {
	LD_FINAL_HASH h;
	unsigned long addr;
} LD_QUERY;

#define SWAPPER_STATUS_SKIP(s)	((s) == -ENOOP || (s) == -ENOTBLK)
#define SWAPPER_STATUS_RETRY(s)	((s) == -ENOTBLK)

#endif
