#ifndef __SPAD_SYNC_H
#define __SPAD_SYNC_H

#include <SPAD/AC.H>
#include <SPAD/DEV.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

void KERNEL$SYNC_IO(IORQ *rq, IO_STUB *call);
void KERNEL$SYNC_IO_SIGINTERRUPT(IORQ *rq, IO_STUB *call);
void KERNEL$SYNC_IO_CANCELABLE(IORQ *rq, IO_STUB *call);

#define SYNC_IO(rq, call)		KERNEL$SYNC_IO((void *)(rq), call)
#define SYNC_IO_SIGINTERRUPT(rq, call)	KERNEL$SYNC_IO_SIGINTERRUPT((void *)(rq), call)
#define SYNC_IO_CANCELABLE(rq, call)	KERNEL$SYNC_IO_CANCELABLE((void *)(rq), call)

IORQ *KERNEL$PREPARE_BLOCK(void);
void KERNEL$BLOCK(IORQ *rq);
extern AST_STUB *KERNEL$UNBLOCK(void);
void KERNEL$THREAD_YIELD(void);

char *KERNEL$ERROR_MSG(void);	/* returns a space of __MAX_STR_LEN characters */
void *KERNEL$TSR_IMAGE(void);
CWD *KERNEL$CWD(void);
void *KERNEL$DLRQ(void);

int KERNEL$STDIN(void);
int KERNEL$STDOUT(void);
int KERNEL$STDERR(void);
int KERNEL$IS_INIT_THREAD(void);

__END_DECLS

#endif
