#ifndef __SPAD_THREAD_H
#define __SPAD_THREAD_H

#include <SPAD/AC.H>
#include <SPAD/DEV.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef struct {
	IORQ_HEAD;
	long (*thread_main)(void *p);
	void *p;
	char *error;	/* thread can put error code here, size is __MAX_STR_LEN */
	CWD *cwd;
	int std_in;
	int std_out;
	int std_err;

	void *dlrq;
	void *thread;	/* preallocated thread structure or NULL */

	char tsr;	/* used by image loader */
	char spawned;	/* result: 1 if thread was spawned, 0 if there was error --- must be set to 0 on call */
	void *thread_internal;	/* used internally --- pointer to thread structure */
} THREAD_RQ;

extern IO_STUB KERNEL$THREAD;

void *KERNEL$ALLOC_THREAD_SYNC(void);
void KERNEL$FREE_THREAD(void *t);

int KERNEL$SET_THREAD_STACK_SIZE(size_t size);
size_t KERNEL$GET_THREAD_STACK_SIZE(void);

THREAD_RQ *KERNEL$THREAD_RQ(void);
void KERNEL$CALL_IN_THREAD(THREAD_RQ *rq, void (*fn)(void *, unsigned), void *data, unsigned data2);

__END_DECLS

#endif
