#ifndef __SPAD_TIMER_H
#define __SPAD_TIMER_H

#include <ARCH/TIME.H>
#include <SPAD/LIST.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

void KERNEL$SET_TIMER(jiffies_t time, TIMER *t);
void KERNEL$DEL_TIMER(TIMER *t);

void KERNEL$SLEEP(jiffies_t time);
int KERNEL$SLEEP_CANCELABLE(jiffies_t time);

static __finline__ void INIT_TIMER(TIMER *t)
{
	t->list.next = NULL;
}

#define DECL_TIMER(t)	TIMER t = { NULL }

__END_DECLS

#endif
