#ifndef __SPAD_VFS_FN_H
#define __SPAD_VFS_FN_H

#include <SPAD/AC.H>
#include <SPAD/DEV_KRNL.H>
#include <SYS/STAT.H>
#include <SYS/STATFS.H>
#include <SYS/TIME.H>
#include <UNISTD.H>
#include <STRING.H>

static int VFS_LSEEK(IOCTLRQ *RQ, _u_off_t size)
{
	void *map;
	FFILE *file;
	_u_off_t seek;
	vspace_unmap_t *unmap, *funmap;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(VFS_FN_SPL))) KERNEL$SUICIDE("VFS_LSEEK AT SPL %08X", KERNEL$SPL);
#endif
	if (__unlikely(RQ->v.len != sizeof(_u_off_t))) return -EINVAL;
	if (__unlikely((unsigned long)RQ->param > SEEK_END)) return -EINVAL;
	RAISE_SPL(SPL_VSPACE);
	map = RQ->v.vspace->op->vspace_map(&RQ->v, PF_RW, &unmap);
	LOWER_SPL(VFS_FN_SPL);
	if (__unlikely(!map)) return 1;
	if (__unlikely(__IS_ERR(map))) return __PTR_ERR(map);
	if (__unlikely((int)(unsigned long)map & (__OFF_T_ALIGN - 1))) {
		RAISE_SPL(SPL_VSPACE);
		unmap(map);
		LOWER_SPL(VFS_FN_SPL);
		return -EINVAL;
	}
	RAISE_SPL(SPL_VSPACE);
	file = KERNEL$MAP_FILE_STRUCT(RQ->handle, (IORQ *)RQ, &funmap);
	LOWER_SPL(VFS_FN_SPL);
	if (__unlikely(!file)) {
		RAISE_SPL(SPL_VSPACE);
		unmap(map);
		LOWER_SPL(VFS_FN_SPL);
		return 2;
	}
	seek = *(_u_off_t *)map;
	switch (RQ->param) {
		case SEEK_END:
			seek += size;
			break;
		case SEEK_CUR:
			seek += file->pos;
			break;
	}
	*(_u_off_t *)map = file->pos = seek;

	RAISE_SPL(SPL_VSPACE);
	funmap(file);
	LOWER_SPL(VFS_FN_SPL);

	RAISE_SPL(SPL_VSPACE);
	unmap(map);
	LOWER_SPL(VFS_FN_SPL);
	return 0;
}

static int VFS_STAT_SLOW(IOCTLRQ *RQ, void *f)
{
	struct stat stat;
	memset(&stat, 0, sizeof(struct stat));
	VFS_FILLSTAT(&stat, f);
	return KERNEL$PUT_IOCTL_STRUCT(RQ, &stat, sizeof stat);
}

static int VFS_STAT(IOCTLRQ *RQ, void *f)
{
	struct stat *stat;
	vspace_unmap_t *unmap;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(VFS_FN_SPL))) KERNEL$SUICIDE("VFS_STAT AT SPL %08X", KERNEL$SPL);
#endif
	if (__unlikely(RQ->v.len != sizeof(struct stat))) return -EINVAL;
	RAISE_SPL(SPL_VSPACE);
	stat = (struct stat *)RQ->v.vspace->op->vspace_map(&RQ->v, PF_WRITE, &unmap);
	LOWER_SPL(VFS_FN_SPL);
	if (__unlikely(!stat)) return 1;
	if (__unlikely(__IS_ERR(stat))) return VFS_STAT_SLOW(RQ, f);
	if (__unlikely((int)(unsigned long)stat & ((__OFF_T_ALIGN - 1) | (__TIME_T_ALIGN - 1)))) {
		RAISE_SPL(SPL_VSPACE);
		unmap(stat);
		LOWER_SPL(VFS_FN_SPL);
		return VFS_STAT_SLOW(RQ, f);
	}
	memset(stat, 0, sizeof(struct stat));
	VFS_FILLSTAT(stat, f);
	RAISE_SPL(SPL_VSPACE);
	unmap(stat);
	LOWER_SPL(VFS_FN_SPL);
	return 0;
}

static int VFS_GETSETFL(IOCTLRQ *RQ)
{
	FFILE *file;
	vspace_unmap_t *unmap;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(VFS_FN_SPL))) KERNEL$SUICIDE("VFS_GETSETFL AT SPL %08X", KERNEL$SPL);
#endif
	RAISE_SPL(SPL_VSPACE);
	file = KERNEL$MAP_FILE_STRUCT(RQ->handle, (IORQ *)RQ, &unmap);
	LOWER_SPL(VFS_FN_SPL);
	if (__unlikely(!file)) return 1;
	if (RQ->ioctl == IOCTL_FCNTL_GETFL) {
		RQ->status = (RQ->param & (~__O_FCNTL_GETFL_IOCTL & ~__LONG_SGN_BIT)) | (file->flags & __O_FCNTL_GETFL_IOCTL);
	} else {
		file->flags = (file->flags & ~__O_FCNTL_SETFL_MASK) | (RQ->param & __O_FCNTL_SETFL_MASK);
		RQ->status = 0;
	}
	RAISE_SPL(SPL_VSPACE);
	unmap(file);
	LOWER_SPL(VFS_FN_SPL);
	return 0;
}

#endif
