#ifndef __SPAD_VMDEF_H
#define __SPAD_VMDEF_H

#include <ARCH/VMDEF.H>
#include <ARCH/SETUP.H>

#define PG_SIZE			(1 << PG_SIZE_BITS)
#define PG_BANK			(1 << PG_BANK_BITS)

#define PG_VIRT_BANKS		(PG_VMMAX / PG_BANK)
#define PG_PHYS_BANKS		(PG_MAX / PG_BANK)


#define N_VM_TYPES			7
#define VM_TYPE_RESERVED		0
#define VM_TYPE_WIRED_MAPPED		1
#define VM_TYPE_WIRED_UNMAPPED		2
#define VM_TYPE_CACHED_MAPPED		3
#define VM_TYPE_CACHED_UNMAPPED		4
#define VM_TYPE_USER_MAPPED		5
#define VM_TYPE_USER_UNMAPPED		6

#define KQM_KERNEL_FREE			13
#define KQM_IO_FREE			14
#define KQM_HIGH_FREE			15

#define KQM_N_ENTRIES			16

#endif
