#ifndef __STDINT_H
#define __STDINT_H

#include <SYS/TYPES.H>

typedef __s8 int_least8_t;
typedef __s16 int_least16_t;
typedef __s32 int_least32_t;
typedef __s64 int_least64_t;

typedef __u8 uint_least8_t;
typedef __u16 uint_least16_t;
typedef __u32 uint_least32_t;
typedef __u64 uint_least64_t;

typedef int int_fast8_t;
typedef int int_fast16_t;
typedef int int_fast32_t;
typedef __s64 int_fast64_t;

typedef unsigned uint_fast8_t;
typedef unsigned uint_fast16_t;
typedef unsigned uint_fast32_t;
typedef __u64 uint_fast64_t;

#if !defined __cplusplus || defined __STDC_LIMIT_MACROS

#define INT8_MIN	(-0x80)
#define INT16_MIN	(-0x8000)
#define INT32_MIN	(-0x7fffffff-1)
#define INT64_MIN	((__s64)1 << 63)

#define INT8_MAX	0x7f
#define INT16_MAX	0x7fff
#define INT32_MAX	0x7fffffff
#define INT64_MAX	((__s64)((__u64)-1 >> 1))

#define UINT8_MAX	0xff
#define UINT16_MAX	0xffff
#define UINT32_MAX	0xffffffffU
#define UINT64_MAX	((__u64)-1)

#define INT_LEAST8_MIN	INT8_MIN
#define INT_LEAST16_MIN	INT16_MIN
#define INT_LEAST32_MIN	INT32_MIN
#define INT_LEAST64_MIN	INT64_MIN

#define INT_LEAST8_MAX	INT8_MAX
#define INT_LEAST16_MAX	INT16_MAX
#define INT_LEAST32_MAX	INT32_MAX
#define INT_LEAST64_MAX	INT64_MAX

#define UINT_LEAST8_MAX	UINT8_MAX
#define UINT_LEAST16_MAX UINT16_MAX
#define UINT_LEAST32_MAX UINT32_MAX
#define UINT_LEAST64_MAX UINT64_MAX

#define INT_FAST8_MIN	INT_MIN
#define INT_FAST16_MIN	INT_MIN
#define INT_FAST32_MIN	INT_MIN
#define INT_FAST64_MIN	INT64_MIN

#define INT_FAST8_MAX	INT_MAX
#define INT_FAST16_MAX	INT_MAX
#define INT_FAST32_MAX	INT_MAX
#define INT_FAST64_MAX	INT64_MAX

#define UINT_FAST8_MAX	UINT_MAX
#define UINT_FAST16_MAX	UINT_MAX
#define UINT_FAST32_MAX	UINT_MAX
#define UINT_FAST64_MAX	UINT64_MAX

#define INTPTR_MIN	LONG_MIN
#define INTPTR_MAX	LONG_MAX
#define UINTPTR_MAX	ULONG_MAX

#define UINTMAX_MAX	((uintmax_t)-1)
#define INTMAX_MAX	((intmax_t)(UINTMAX_MAX >> 1))
#define INTMAX_MIN	(-INTMAX_MAX - 1)

#define PTRDIFF_MIN	SSIZE_T_MIN
#define PTRDIFF_MAX	SSIZE_T_MAX

#endif

#endif
