#ifndef __STDLIB_H
#define __STDLIB_H

#include <SYS/TYPES.H>
#include <ALLOCA.H>
#include <SPAD/SLAB.H>

__BEGIN_DECLS

extern char **environ;
char *getenv(__const__ char *__name);
int _setenv(__const__ char *__name, __const__ char *__value, int __rewrite, size_t *__failsize);
int setenv(__const__ char *__name, __const__ char *__value, int __rewrite);
void unsetenv(__const__ char *__name);
int _putenv(__const__ char *__name_value, size_t *__failsize);
int putenv(__const__ char *__name_value);

int rand(void);
void srand(unsigned int __seed);
long int random(void);
void srandom(unsigned int __seed);
char *initstate(unsigned seed, char *state, size_t size);
char *setstate(char *state);

__END_DECLS

/* copied from freebsd4/include/stdlib.h and modified */
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)stdlib.h	8.5 (Berkeley) 5/19/95
 * $FreeBSD: src/include/stdlib.h,v 1.16.2.5 2002/12/13 01:34:00 tjr Exp $
 */

typedef struct {
	int quot;		/* quotient */
	int rem;		/* remainder */
} div_t;

typedef struct {
	long quot;		/* quotient */
	long rem;		/* remainder */
} ldiv_t;

#define RAND_MAX	0x7fffffff

#define EXIT_FAILURE	1
#define EXIT_SUCCESS	0

extern int __mb_cur_max;
#define MB_CUR_MAX __mb_cur_max

__BEGIN_DECLS


void	 abort __P((void)) __NORET_ATTR__;
int	 abs __P((int)) __CONST_ATTR__;
int	 atexit __P((void (*)(void)));
double	 atof __P((const char *));
int	 atoi __P((const char *));
long	 atol __P((const char *));
long long atoll __P((const char *));
void	*bsearch __P((const void *, const void *, size_t,
	    size_t, int (*)(const void *, const void *)));
div_t	 div (int, int) __CONST_ATTR__;
void	 exit __P((int)) __NORET_ATTR__;
int	 heapsort __P((void *, size_t, size_t,
	    int (*)(const void *, const void *)));
long	 labs __P((long)) __CONST_ATTR__;
ldiv_t	 ldiv __P((long, long)) __CONST_ATTR__;
int	 mergesort __P((void *, size_t, size_t,
	    int (*)(const void *, const void *)));
char	*realpath __P((const char *, char resolved_path[]));
void	 qsort __P((void *, size_t, size_t,
	    int (*)(const void *, const void *)));
int	 radixsort __P((const unsigned char **, int, const unsigned char *,
	    unsigned));
int	 sradixsort __P((const unsigned char **, int, const unsigned char *,
	    unsigned));
double	 strtod __P((const char *, char **));
float	 strtof __P((const char *, char **));
#ifndef __STRICT_ANSI__
int64_t	 strtoq __P((const char *, char **, int));
uint64_t
	 strtouq __P((const char *, char **, int));
#endif
long	 strtol __P((const char *, char **, int));
#ifdef __LONG_LONG_SUPPORTED
long long	 
	 strtoll __P((const char *, char **, int));
#endif
unsigned long
	 strtoul __P((const char *, char **, int));
#ifdef __LONG_LONG_SUPPORTED
unsigned long long
	 strtoull __P((const char *, char **, int));
#endif

int mblen __P((const char *, size_t));
size_t mbstowcs __P((__wchar_t *, const char *, size_t));
int wctomb __P((char *, __wchar_t));
int mbtowc __P((__wchar_t *, const char *, size_t));
size_t wcstombs __P((char *, const __wchar_t *, size_t));

int	daemon __P((int, int));
char	*getbsize __P((int *, long *));
__const__ char *getprogname __P((void));
void	setprogname __P((const char *));
int	system __P((const char *__string));

int rpmatch(const char *);

uint32_t arc4random(void);
uint32_t arc4random_nonblock(void);
int arc4random_error(void);
int arc4random_stir(void);
void arc4random_addrandom(unsigned char *, int);
void arc4random_invalidate(void);

__END_DECLS

#endif
