#ifndef __STRING_H
#define __STRING_H

#include <ARCH/STRING.H>

__BEGIN_DECLS

#ifndef __static__
#define __static__ static
#endif

#ifdef __NO_INLINES
void bcopy(__const__ void *__src, void *__dest, int __n);
#else
__static__ __finline__ void bcopy(__const__ void *__src, void *__dest, int __n)
{
	memmove(__dest, __src, __n);
}
#endif

#ifdef __NO_INLINES
void bzero(void *__s, int __n);
#else
__static__ __finline__ void bzero(void *__s, int __n)
{
	memset(__s, 0, __n);
}
#endif

#ifdef __NO_INLINES
int bcmp(__const__ void *__s1, __const__ void *__s2, int __n);
#else
__static__ __finline__ int bcmp(__const__ void *__s1, __const__ void *__s2, int __n)
{
	return memcmp(__s1, __s2, __n);
}
#endif

#ifdef __NO_INLINES
char *index(const char *__s, int __c);
#else
__static__ __finline__ char *index(const char *__s, int __c)
{
	return strchr(__s, __c);
}
#endif

#ifdef __NO_INLINES
char *rindex(const char *__s, int __c);
#else
__static__ __finline__ char *rindex(const char *__s, int __c)
{
	return strrchr(__s, __c);
}
#endif

char *strerror(int __errnum);
char *strsignal(int __signum);

char	*strpbrk __P((const char *, const char *));
size_t	strspn __P((const char *, const char *));
size_t	strcspn __P((const char *, const char *));
char	*strtok __P((char *, const char *));
size_t	strxfrm __P((char *, const char *, size_t));

#if !defined(_ANSI_SOURCE) && !defined(_POSIX_SOURCE)
void	*memccpy __P((void *, const void *, int, size_t));
int	strcoll __P((__const__ char *s1, __const__ char *s2));
int	strcasecmp __P((const char *, const char *));
int	strncasecmp __P((const char *, const char *, size_t));
char	*strcasestr __P((const char *, const char *));
char	*strdup __P((const char *));
void	strmode __P((mode_t, char *));
char	*strnstr __P((const char *, const char *, size_t));
char	*strsep __P((char **, const char *));
char	*strtok_r __P((char *, const char *, char **));
#endif

__END_DECLS

#endif
