#ifndef __SYS_MMAN_H
#define __SYS_MMAN_H

#include <SYS/TYPES.H>

__BEGIN_DECLS

#define PROT_NONE	0x0
#define PROT_READ	0x1
#define PROT_WRITE	0x2
#define PROT_EXEC	0x4
#define __PROT_WRITTEN	0x8	/* set when PROT_WRITE is set or was set some times ago */

#define MAP_FILE	0x00
#define MAP_SHARED	0x10
#define MAP_PRIVATE	0x20
#define MAP_ANONYMOUS	0x40
#define MAP_ANON	MAP_ANONYMOUS
#define MAP_INHERIT	0x80
#define _MAP_NOFAULT	0x100

#define MAP_FIXED	0x1000
#define _MAP_NOUNMAP	0x2000
#define _MAP_NODEALLOC	0x4000
#define _MAP_IMMEDIATE	0x8000

#define MAP_FAILED	((void *)-1L)

void *mmap(void *__start, size_t __length, int __prot, int __flags, int __h, off_t __offset);
int munmap(void *__start, size_t __length);
int mprotect(void *__start, size_t __length, int __prot);
int msync(void *__start, size_t __length, int __flags);

int _merror(void *__start, size_t __length);

#define MS_ASYNC	1
#define MS_INVALIDATE	2
#define MS_SYNC		4

__END_DECLS

#endif
