#ifndef __SYS_PARAM_H
#define __SYS_PARAM_H

#include <SYS/TYPES.H>
#include <LIMITS.H>

#define setbit(a,i)	((a)[(i)/NBBY] |= 1<<((i) & (NBBY - 1)))
#define clrbit(a,i)	((a)[(i)/NBBY] &= ~(1<<((i) & (NBBY - 1))))
#define isset(a,i)	((a)[(i)/NBBY] & (1<<((i) & (NBBY - 1))))
#define isclr(a,i)	(((a)[(i)/NBBY] & (1<<((i) & (NBBY - 1)))) == 0)

/*#define howmany(x, y)	(((x)+((y)-1))/(y))*/
#define roundup(x, y)	((((x)+((y)-1))/(y))*(y))
#define powerof2(x)	((((x)-1)&(x))==0)

#define MIN(a,b)	(((a)<(b))?(a):(b))
#define MAX(a,b)	(((a)>(b))?(a):(b))

#define ALIGNBYTES	(__MALLOC_ALIGN - 1)
#define ALIGN(x)	(((unsigned long)(x) + ALIGNBYTES) & ~(unsigned long)ALIGNBYTES)

#endif
